/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectFacility;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectFacilityRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectFacility")
    @NotNull
    @Valid
    private ProjectFacility projectFacility;

    public static ProjectFacilityRequestBuilder builder() {
        return new ProjectFacilityRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public ProjectFacility getProjectFacility() {
        return this.projectFacility;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectFacility")
    public void setProjectFacility(ProjectFacility projectFacility) {
        this.projectFacility = projectFacility;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFacilityRequest)) {
            return false;
        }
        ProjectFacilityRequest other = (ProjectFacilityRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        ProjectFacility this$projectFacility = this.getProjectFacility();
        ProjectFacility other$projectFacility = other.getProjectFacility();
        return !(this$projectFacility == null ? other$projectFacility != null : !((Object)this$projectFacility).equals(other$projectFacility));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectFacilityRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        ProjectFacility $projectFacility = this.getProjectFacility();
        result = result * 59 + ($projectFacility == null ? 43 : ((Object)$projectFacility).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectFacilityRequest(requestInfo=" + this.getRequestInfo() + ", projectFacility=" + this.getProjectFacility() + ")";
    }

    public ProjectFacilityRequest() {
    }

    public ProjectFacilityRequest(RequestInfo requestInfo, ProjectFacility projectFacility) {
        this.requestInfo = requestInfo;
        this.projectFacility = projectFacility;
    }

    public static class ProjectFacilityRequestBuilder {
        private RequestInfo requestInfo;
        private ProjectFacility projectFacility;

        ProjectFacilityRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectFacilityRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectFacility")
        public ProjectFacilityRequestBuilder projectFacility(ProjectFacility projectFacility) {
            this.projectFacility = projectFacility;
            return this;
        }

        public ProjectFacilityRequest build() {
            return new ProjectFacilityRequest(this.requestInfo, this.projectFacility);
        }

        public String toString() {
            return "ProjectFacilityRequest.ProjectFacilityRequestBuilder(requestInfo=" + this.requestInfo + ", projectFacility=" + this.projectFacility + ")";
        }
    }
}

