/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.individual.Address;
import org.egov.common.models.individual.BloodGroup;
import org.egov.common.models.individual.Gender;
import org.egov.common.models.individual.Identifier;
import org.egov.common.models.individual.Name;
import org.egov.common.models.individual.Skill;
import org.egov.common.models.individual.UserDetails;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Individual
extends EgovOfflineModel {
    @JsonProperty(value="individualId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualId = null;
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="userUuid")
    private String userUuid = null;
    @JsonProperty(value="name")
    @NotNull
    @Valid
    private Name name = null;
    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    private Date dateOfBirth = null;
    @JsonProperty(value="gender")
    @Valid
    private Gender gender = null;
    @JsonProperty(value="bloodGroup")
    @Valid
    private BloodGroup bloodGroup = null;
    @JsonProperty(value="mobileNumber")
    @Size(max=20)
    private @Size(max=20) String mobileNumber = null;
    @Size(max=20)
    private @Size(max=20) String hashedmobilenumber = null;
    @JsonProperty(value="altContactNumber")
    @Size(max=16)
    private @Size(max=16) String altContactNumber = null;
    @JsonProperty(value="email")
    @Size(min=5, max=200)
    private @Size(min=5, max=200) String email = null;
    @JsonProperty(value="address")
    @Valid
    @Size(max=3)
    private @Valid @Size(max=3) List<Address> address = null;
    @JsonProperty(value="fatherName")
    @Size(max=100)
    private @Size(max=100) String fatherName = null;
    @JsonProperty(value="husbandName")
    @Size(max=100)
    private @Size(max=100) String husbandName = null;
    @JsonProperty(value="relationship")
    @Size(max=100, min=1)
    private @Size(max=100, min=1) String relationship = null;
    @JsonProperty(value="identifiers")
    @Valid
    private List<Identifier> identifiers = null;
    @JsonProperty(value="skills")
    @Valid
    private List<Skill> skills = null;
    @JsonProperty(value="photo")
    private String photo = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="isSystemUser")
    private Boolean isSystemUser = Boolean.FALSE;
    @JsonProperty(value="isSystemUserActive")
    private Boolean isSystemUserActive = Boolean.TRUE;
    @JsonProperty(value="userDetails")
    private UserDetails userDetails;

    public Individual addAddressItem(Address addressItem) {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(addressItem);
        return this;
    }

    public Individual addIdentifiersItem(Identifier identifiersItem) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifiersItem);
        return this;
    }

    public Individual addSkillsItem(Skill skillItem) {
        if (this.skills == null) {
            this.skills = new ArrayList<Skill>();
        }
        this.skills.add(skillItem);
        return this;
    }

    protected Individual(IndividualBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.individualId = b.individualId;
        this.userId = b.userId;
        this.userUuid = b.userUuid;
        this.name = b.name;
        this.dateOfBirth = b.dateOfBirth;
        this.gender = b.gender;
        this.bloodGroup = b.bloodGroup;
        this.mobileNumber = b.mobileNumber;
        this.hashedmobilenumber = b.hashedmobilenumber;
        this.altContactNumber = b.altContactNumber;
        this.email = b.email;
        this.address = b.address;
        this.fatherName = b.fatherName;
        this.husbandName = b.husbandName;
        this.relationship = b.relationship;
        this.identifiers = b.identifiers;
        this.skills = b.skills;
        this.photo = b.photo;
        this.isDeleted = b.isDeleted;
        this.isSystemUser = b.isSystemUser;
        this.isSystemUserActive = b.isSystemUserActive;
        this.userDetails = b.userDetails;
    }

    public static IndividualBuilder<?, ?> builder() {
        return new IndividualBuilderImpl();
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserUuid() {
        return this.userUuid;
    }

    public Name getName() {
        return this.name;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public BloodGroup getBloodGroup() {
        return this.bloodGroup;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getHashedmobilenumber() {
        return this.hashedmobilenumber;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public String getHusbandName() {
        return this.husbandName;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public List<Skill> getSkills() {
        return this.skills;
    }

    public String getPhoto() {
        return this.photo;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Boolean getIsSystemUser() {
        return this.isSystemUser;
    }

    public Boolean getIsSystemUserActive() {
        return this.isSystemUserActive;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="userUuid")
    public void setUserUuid(String userUuid) {
        this.userUuid = userUuid;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="gender")
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JsonProperty(value="bloodGroup")
    public void setBloodGroup(BloodGroup bloodGroup) {
        this.bloodGroup = bloodGroup;
    }

    @JsonProperty(value="mobileNumber")
    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setHashedmobilenumber(String hashedmobilenumber) {
        this.hashedmobilenumber = hashedmobilenumber;
    }

    @JsonProperty(value="altContactNumber")
    public void setAltContactNumber(String altContactNumber) {
        this.altContactNumber = altContactNumber;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="address")
    public void setAddress(List<Address> address) {
        this.address = address;
    }

    @JsonProperty(value="fatherName")
    public void setFatherName(String fatherName) {
        this.fatherName = fatherName;
    }

    @JsonProperty(value="husbandName")
    public void setHusbandName(String husbandName) {
        this.husbandName = husbandName;
    }

    @JsonProperty(value="relationship")
    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="skills")
    public void setSkills(List<Skill> skills) {
        this.skills = skills;
    }

    @JsonProperty(value="photo")
    public void setPhoto(String photo) {
        this.photo = photo;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="isSystemUser")
    public void setIsSystemUser(Boolean isSystemUser) {
        this.isSystemUser = isSystemUser;
    }

    @JsonProperty(value="isSystemUserActive")
    public void setIsSystemUserActive(Boolean isSystemUserActive) {
        this.isSystemUserActive = isSystemUserActive;
    }

    @JsonProperty(value="userDetails")
    public void setUserDetails(UserDetails userDetails) {
        this.userDetails = userDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Individual)) {
            return false;
        }
        Individual other = (Individual)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Boolean this$isSystemUser = this.getIsSystemUser();
        Boolean other$isSystemUser = other.getIsSystemUser();
        if (this$isSystemUser == null ? other$isSystemUser != null : !((Object)this$isSystemUser).equals(other$isSystemUser)) {
            return false;
        }
        Boolean this$isSystemUserActive = this.getIsSystemUserActive();
        Boolean other$isSystemUserActive = other.getIsSystemUserActive();
        if (this$isSystemUserActive == null ? other$isSystemUserActive != null : !((Object)this$isSystemUserActive).equals(other$isSystemUserActive)) {
            return false;
        }
        String this$individualId = this.getIndividualId();
        String other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !this$individualId.equals(other$individualId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userUuid = this.getUserUuid();
        String other$userUuid = other.getUserUuid();
        if (this$userUuid == null ? other$userUuid != null : !this$userUuid.equals(other$userUuid)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Date this$dateOfBirth = this.getDateOfBirth();
        Date other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        BloodGroup this$bloodGroup = this.getBloodGroup();
        BloodGroup other$bloodGroup = other.getBloodGroup();
        if (this$bloodGroup == null ? other$bloodGroup != null : !((Object)((Object)this$bloodGroup)).equals((Object)other$bloodGroup)) {
            return false;
        }
        String this$mobileNumber = this.getMobileNumber();
        String other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !this$mobileNumber.equals(other$mobileNumber)) {
            return false;
        }
        String this$hashedmobilenumber = this.getHashedmobilenumber();
        String other$hashedmobilenumber = other.getHashedmobilenumber();
        if (this$hashedmobilenumber == null ? other$hashedmobilenumber != null : !this$hashedmobilenumber.equals(other$hashedmobilenumber)) {
            return false;
        }
        String this$altContactNumber = this.getAltContactNumber();
        String other$altContactNumber = other.getAltContactNumber();
        if (this$altContactNumber == null ? other$altContactNumber != null : !this$altContactNumber.equals(other$altContactNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        List<Address> this$address = this.getAddress();
        List<Address> other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$fatherName = this.getFatherName();
        String other$fatherName = other.getFatherName();
        if (this$fatherName == null ? other$fatherName != null : !this$fatherName.equals(other$fatherName)) {
            return false;
        }
        String this$husbandName = this.getHusbandName();
        String other$husbandName = other.getHusbandName();
        if (this$husbandName == null ? other$husbandName != null : !this$husbandName.equals(other$husbandName)) {
            return false;
        }
        String this$relationship = this.getRelationship();
        String other$relationship = other.getRelationship();
        if (this$relationship == null ? other$relationship != null : !this$relationship.equals(other$relationship)) {
            return false;
        }
        List<Identifier> this$identifiers = this.getIdentifiers();
        List<Identifier> other$identifiers = other.getIdentifiers();
        if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
            return false;
        }
        List<Skill> this$skills = this.getSkills();
        List<Skill> other$skills = other.getSkills();
        if (this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills)) {
            return false;
        }
        String this$photo = this.getPhoto();
        String other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !this$photo.equals(other$photo)) {
            return false;
        }
        UserDetails this$userDetails = this.getUserDetails();
        UserDetails other$userDetails = other.getUserDetails();
        return !(this$userDetails == null ? other$userDetails != null : !((Object)this$userDetails).equals(other$userDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Individual;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Boolean $isSystemUser = this.getIsSystemUser();
        result = result * 59 + ($isSystemUser == null ? 43 : ((Object)$isSystemUser).hashCode());
        Boolean $isSystemUserActive = this.getIsSystemUserActive();
        result = result * 59 + ($isSystemUserActive == null ? 43 : ((Object)$isSystemUserActive).hashCode());
        String $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : $individualId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userUuid = this.getUserUuid();
        result = result * 59 + ($userUuid == null ? 43 : $userUuid.hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Date $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        BloodGroup $bloodGroup = this.getBloodGroup();
        result = result * 59 + ($bloodGroup == null ? 43 : ((Object)((Object)$bloodGroup)).hashCode());
        String $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : $mobileNumber.hashCode());
        String $hashedmobilenumber = this.getHashedmobilenumber();
        result = result * 59 + ($hashedmobilenumber == null ? 43 : $hashedmobilenumber.hashCode());
        String $altContactNumber = this.getAltContactNumber();
        result = result * 59 + ($altContactNumber == null ? 43 : $altContactNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        List<Address> $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $fatherName = this.getFatherName();
        result = result * 59 + ($fatherName == null ? 43 : $fatherName.hashCode());
        String $husbandName = this.getHusbandName();
        result = result * 59 + ($husbandName == null ? 43 : $husbandName.hashCode());
        String $relationship = this.getRelationship();
        result = result * 59 + ($relationship == null ? 43 : $relationship.hashCode());
        List<Identifier> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        List<Skill> $skills = this.getSkills();
        result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
        String $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : $photo.hashCode());
        UserDetails $userDetails = this.getUserDetails();
        result = result * 59 + ($userDetails == null ? 43 : ((Object)$userDetails).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Individual(individualId=" + this.getIndividualId() + ", userId=" + this.getUserId() + ", userUuid=" + this.getUserUuid() + ", name=" + this.getName() + ", dateOfBirth=" + this.getDateOfBirth() + ", gender=" + this.getGender() + ", bloodGroup=" + this.getBloodGroup() + ", mobileNumber=" + this.getMobileNumber() + ", hashedmobilenumber=" + this.getHashedmobilenumber() + ", altContactNumber=" + this.getAltContactNumber() + ", email=" + this.getEmail() + ", address=" + this.getAddress() + ", fatherName=" + this.getFatherName() + ", husbandName=" + this.getHusbandName() + ", relationship=" + this.getRelationship() + ", identifiers=" + this.getIdentifiers() + ", skills=" + this.getSkills() + ", photo=" + this.getPhoto() + ", isDeleted=" + this.getIsDeleted() + ", isSystemUser=" + this.getIsSystemUser() + ", isSystemUserActive=" + this.getIsSystemUserActive() + ", userDetails=" + this.getUserDetails() + ")";
    }

    public Individual() {
    }

    public Individual(String individualId, String userId, String userUuid, Name name, Date dateOfBirth, Gender gender, BloodGroup bloodGroup, String mobileNumber, String hashedmobilenumber, String altContactNumber, String email, List<Address> address, String fatherName, String husbandName, String relationship, List<Identifier> identifiers, List<Skill> skills, String photo, Boolean isDeleted, Boolean isSystemUser, Boolean isSystemUserActive, UserDetails userDetails) {
        this.individualId = individualId;
        this.userId = userId;
        this.userUuid = userUuid;
        this.name = name;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.bloodGroup = bloodGroup;
        this.mobileNumber = mobileNumber;
        this.hashedmobilenumber = hashedmobilenumber;
        this.altContactNumber = altContactNumber;
        this.email = email;
        this.address = address;
        this.fatherName = fatherName;
        this.husbandName = husbandName;
        this.relationship = relationship;
        this.identifiers = identifiers;
        this.skills = skills;
        this.photo = photo;
        this.isDeleted = isDeleted;
        this.isSystemUser = isSystemUser;
        this.isSystemUserActive = isSystemUserActive;
        this.userDetails = userDetails;
    }

    public static abstract class IndividualBuilder<C extends Individual, B extends IndividualBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String individualId;
        private String userId;
        private String userUuid;
        private Name name;
        private Date dateOfBirth;
        private Gender gender;
        private BloodGroup bloodGroup;
        private String mobileNumber;
        private String hashedmobilenumber;
        private String altContactNumber;
        private String email;
        private List<Address> address;
        private String fatherName;
        private String husbandName;
        private String relationship;
        private List<Identifier> identifiers;
        private List<Skill> skills;
        private String photo;
        private Boolean isDeleted;
        private Boolean isSystemUser;
        private Boolean isSystemUserActive;
        private UserDetails userDetails;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="individualId")
        public B individualId(String individualId) {
            this.individualId = individualId;
            return (B)this.self();
        }

        @JsonProperty(value="userId")
        public B userId(String userId) {
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="userUuid")
        public B userUuid(String userUuid) {
            this.userUuid = userUuid;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        public B name(Name name) {
            this.name = name;
            return (B)this.self();
        }

        @JsonProperty(value="dateOfBirth")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
        public B dateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return (B)this.self();
        }

        @JsonProperty(value="gender")
        public B gender(Gender gender) {
            this.gender = gender;
            return (B)this.self();
        }

        @JsonProperty(value="bloodGroup")
        public B bloodGroup(BloodGroup bloodGroup) {
            this.bloodGroup = bloodGroup;
            return (B)this.self();
        }

        @JsonProperty(value="mobileNumber")
        public B mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return (B)this.self();
        }

        public B hashedmobilenumber(String hashedmobilenumber) {
            this.hashedmobilenumber = hashedmobilenumber;
            return (B)this.self();
        }

        @JsonProperty(value="altContactNumber")
        public B altContactNumber(String altContactNumber) {
            this.altContactNumber = altContactNumber;
            return (B)this.self();
        }

        @JsonProperty(value="email")
        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        @JsonProperty(value="address")
        public B address(List<Address> address) {
            this.address = address;
            return (B)this.self();
        }

        @JsonProperty(value="fatherName")
        public B fatherName(String fatherName) {
            this.fatherName = fatherName;
            return (B)this.self();
        }

        @JsonProperty(value="husbandName")
        public B husbandName(String husbandName) {
            this.husbandName = husbandName;
            return (B)this.self();
        }

        @JsonProperty(value="relationship")
        public B relationship(String relationship) {
            this.relationship = relationship;
            return (B)this.self();
        }

        @JsonProperty(value="identifiers")
        public B identifiers(List<Identifier> identifiers) {
            this.identifiers = identifiers;
            return (B)this.self();
        }

        @JsonProperty(value="skills")
        public B skills(List<Skill> skills) {
            this.skills = skills;
            return (B)this.self();
        }

        @JsonProperty(value="photo")
        public B photo(String photo) {
            this.photo = photo;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @JsonProperty(value="isSystemUser")
        public B isSystemUser(Boolean isSystemUser) {
            this.isSystemUser = isSystemUser;
            return (B)this.self();
        }

        @JsonProperty(value="isSystemUserActive")
        public B isSystemUserActive(Boolean isSystemUserActive) {
            this.isSystemUserActive = isSystemUserActive;
            return (B)this.self();
        }

        @JsonProperty(value="userDetails")
        public B userDetails(UserDetails userDetails) {
            this.userDetails = userDetails;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Individual.IndividualBuilder(super=" + super.toString() + ", individualId=" + this.individualId + ", userId=" + this.userId + ", userUuid=" + this.userUuid + ", name=" + this.name + ", dateOfBirth=" + this.dateOfBirth + ", gender=" + this.gender + ", bloodGroup=" + this.bloodGroup + ", mobileNumber=" + this.mobileNumber + ", hashedmobilenumber=" + this.hashedmobilenumber + ", altContactNumber=" + this.altContactNumber + ", email=" + this.email + ", address=" + this.address + ", fatherName=" + this.fatherName + ", husbandName=" + this.husbandName + ", relationship=" + this.relationship + ", identifiers=" + this.identifiers + ", skills=" + this.skills + ", photo=" + this.photo + ", isDeleted=" + this.isDeleted + ", isSystemUser=" + this.isSystemUser + ", isSystemUserActive=" + this.isSystemUserActive + ", userDetails=" + this.userDetails + ")";
        }
    }

    private static final class IndividualBuilderImpl
    extends IndividualBuilder<Individual, IndividualBuilderImpl> {
        private IndividualBuilderImpl() {
        }

        @Override
        protected IndividualBuilderImpl self() {
            return this;
        }

        @Override
        public Individual build() {
            return new Individual(this);
        }
    }
}

