/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement.hfreferral;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.referralmanagement.hfreferral.HFReferral;

public class HFReferralBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo;
    @JsonProperty(value="HFReferrals")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<HFReferral> hfReferrals;

    public HFReferralBulkRequest addHFReferralItem(HFReferral hfReferralItem) {
        if (Objects.isNull(this.hfReferrals)) {
            this.hfReferrals = new ArrayList<HFReferral>();
        }
        if (Objects.nonNull(hfReferralItem)) {
            this.hfReferrals.add(hfReferralItem);
        }
        return this;
    }

    public static HFReferralBulkRequestBuilder builder() {
        return new HFReferralBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<HFReferral> getHfReferrals() {
        return this.hfReferrals;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="HFReferrals")
    public void setHfReferrals(List<HFReferral> hfReferrals) {
        this.hfReferrals = hfReferrals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HFReferralBulkRequest)) {
            return false;
        }
        HFReferralBulkRequest other = (HFReferralBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<HFReferral> this$hfReferrals = this.getHfReferrals();
        List<HFReferral> other$hfReferrals = other.getHfReferrals();
        return !(this$hfReferrals == null ? other$hfReferrals != null : !((Object)this$hfReferrals).equals(other$hfReferrals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HFReferralBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<HFReferral> $hfReferrals = this.getHfReferrals();
        result = result * 59 + ($hfReferrals == null ? 43 : ((Object)$hfReferrals).hashCode());
        return result;
    }

    public String toString() {
        return "HFReferralBulkRequest(requestInfo=" + this.getRequestInfo() + ", hfReferrals=" + this.getHfReferrals() + ")";
    }

    public HFReferralBulkRequest() {
    }

    public HFReferralBulkRequest(RequestInfo requestInfo, List<HFReferral> hfReferrals) {
        this.requestInfo = requestInfo;
        this.hfReferrals = hfReferrals;
    }

    public static class HFReferralBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<HFReferral> hfReferrals;

        HFReferralBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HFReferralBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="HFReferrals")
        public HFReferralBulkRequestBuilder hfReferrals(List<HFReferral> hfReferrals) {
            this.hfReferrals = hfReferrals;
            return this;
        }

        public HFReferralBulkRequest build() {
            return new HFReferralBulkRequest(this.requestInfo, this.hfReferrals);
        }

        public String toString() {
            return "HFReferralBulkRequest.HFReferralBulkRequestBuilder(requestInfo=" + this.requestInfo + ", hfReferrals=" + this.hfReferrals + ")";
        }
    }
}

