/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.referralmanagement.Referral;

public class ReferralBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo;
    @JsonProperty(value="Referrals")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Referral> referrals;

    public ReferralBulkRequest addReferralItem(Referral referralItem) {
        if (Objects.isNull(this.referrals)) {
            this.referrals = new ArrayList<Referral>();
        }
        if (Objects.nonNull(referralItem)) {
            this.referrals.add(referralItem);
        }
        return this;
    }

    public static ReferralBulkRequestBuilder builder() {
        return new ReferralBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Referral> getReferrals() {
        return this.referrals;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Referrals")
    public void setReferrals(List<Referral> referrals) {
        this.referrals = referrals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferralBulkRequest)) {
            return false;
        }
        ReferralBulkRequest other = (ReferralBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Referral> this$referrals = this.getReferrals();
        List<Referral> other$referrals = other.getReferrals();
        return !(this$referrals == null ? other$referrals != null : !((Object)this$referrals).equals(other$referrals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferralBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Referral> $referrals = this.getReferrals();
        result = result * 59 + ($referrals == null ? 43 : ((Object)$referrals).hashCode());
        return result;
    }

    public String toString() {
        return "ReferralBulkRequest(requestInfo=" + this.getRequestInfo() + ", referrals=" + this.getReferrals() + ")";
    }

    public ReferralBulkRequest() {
    }

    public ReferralBulkRequest(RequestInfo requestInfo, List<Referral> referrals) {
        this.requestInfo = requestInfo;
        this.referrals = referrals;
    }

    public static class ReferralBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Referral> referrals;

        ReferralBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ReferralBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Referrals")
        public ReferralBulkRequestBuilder referrals(List<Referral> referrals) {
            this.referrals = referrals;
            return this;
        }

        public ReferralBulkRequest build() {
            return new ReferralBulkRequest(this.requestInfo, this.referrals);
        }

        public String toString() {
            return "ReferralBulkRequest.ReferralBulkRequestBuilder(requestInfo=" + this.requestInfo + ", referrals=" + this.referrals + ")";
        }
    }
}

