/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.facility;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.facility.Facility;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class FacilityBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Facilities")
    @Valid
    private List<Facility> facilities = null;

    public FacilityBulkResponse addFacilityItem(Facility facilityItem) {
        if (this.facilities == null) {
            this.facilities = new ArrayList<Facility>();
        }
        this.facilities.add(facilityItem);
        return this;
    }

    public static FacilityBulkResponseBuilder builder() {
        return new FacilityBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Facility> getFacilities() {
        return this.facilities;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Facilities")
    public void setFacilities(List<Facility> facilities) {
        this.facilities = facilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacilityBulkResponse)) {
            return false;
        }
        FacilityBulkResponse other = (FacilityBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Facility> this$facilities = this.getFacilities();
        List<Facility> other$facilities = other.getFacilities();
        return !(this$facilities == null ? other$facilities != null : !((Object)this$facilities).equals(other$facilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FacilityBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Facility> $facilities = this.getFacilities();
        result = result * 59 + ($facilities == null ? 43 : ((Object)$facilities).hashCode());
        return result;
    }

    public String toString() {
        return "FacilityBulkResponse(responseInfo=" + this.getResponseInfo() + ", facilities=" + this.getFacilities() + ")";
    }

    public FacilityBulkResponse() {
    }

    public FacilityBulkResponse(ResponseInfo responseInfo, List<Facility> facilities) {
        this.responseInfo = responseInfo;
        this.facilities = facilities;
    }

    public static class FacilityBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Facility> facilities;

        FacilityBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public FacilityBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Facilities")
        public FacilityBulkResponseBuilder facilities(List<Facility> facilities) {
            this.facilities = facilities;
            return this;
        }

        public FacilityBulkResponse build() {
            return new FacilityBulkResponse(this.responseInfo, this.facilities);
        }

        public String toString() {
            return "FacilityBulkResponse.FacilityBulkResponseBuilder(responseInfo=" + this.responseInfo + ", facilities=" + this.facilities + ")";
        }
    }
}

