/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.common.models.core.EgovOfflineSearchModel;
import org.egov.common.models.core.Exclude;
import org.egov.common.models.individual.Gender;
import org.egov.common.models.individual.Identifier;
import org.egov.common.models.individual.Name;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndividualSearch
extends EgovOfflineSearchModel {
    @JsonProperty(value="individualId")
    private List<String> individualId = null;
    @JsonProperty(value="name")
    @Valid
    private Name name = null;
    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    private Date dateOfBirth = null;
    @JsonProperty(value="gender")
    @Valid
    private Gender gender = null;
    @JsonProperty(value="mobileNumber")
    private List<String> mobileNumber = null;
    @JsonProperty(value="socialCategory")
    @Exclude
    private String socialCategory = null;
    @JsonProperty(value="wardCode")
    @Exclude
    private String wardCode = null;
    @JsonProperty(value="individualName")
    @Exclude
    private String individualName = null;
    @JsonProperty(value="createdFrom")
    @Exclude
    private BigDecimal createdFrom = null;
    @JsonProperty(value="createdTo")
    @Exclude
    private BigDecimal createdTo = null;
    @JsonProperty(value="identifier")
    @Valid
    @Exclude
    private Identifier identifier = null;
    @JsonProperty(value="boundaryCode")
    @Exclude
    private String boundaryCode = null;
    @JsonProperty(value="roleCodes")
    @Exclude
    private List<String> roleCodes = null;
    @JsonProperty(value="username")
    @Exclude
    private List<String> username;
    @JsonProperty(value="userId")
    @Exclude
    private List<Long> userId;
    @JsonProperty(value="userUuid")
    @Size(min=1)
    @Exclude
    private @Size(min=1) List<String> userUuid;
    @Exclude
    @JsonProperty(value="latitude")
    @DecimalMin(value="-90")
    @DecimalMax(value="90")
    private @DecimalMin(value="-90") @DecimalMax(value="90") Double latitude;
    @Exclude
    @JsonProperty(value="longitude")
    @DecimalMin(value="-180")
    @DecimalMax(value="180")
    private @DecimalMin(value="-180") @DecimalMax(value="180") Double longitude;
    @Exclude
    @JsonProperty(value="searchRadius")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Double searchRadius;
    @JsonProperty(value="type")
    private String type;

    protected IndividualSearch(IndividualSearchBuilder<?, ?> b) {
        super((EgovOfflineSearchModel.EgovOfflineSearchModelBuilder<?, ?>)b);
        this.individualId = b.individualId;
        this.name = b.name;
        this.dateOfBirth = b.dateOfBirth;
        this.gender = b.gender;
        this.mobileNumber = b.mobileNumber;
        this.socialCategory = b.socialCategory;
        this.wardCode = b.wardCode;
        this.individualName = b.individualName;
        this.createdFrom = b.createdFrom;
        this.createdTo = b.createdTo;
        this.identifier = b.identifier;
        this.boundaryCode = b.boundaryCode;
        this.roleCodes = b.roleCodes;
        this.username = b.username;
        this.userId = b.userId;
        this.userUuid = b.userUuid;
        this.latitude = b.latitude;
        this.longitude = b.longitude;
        this.searchRadius = b.searchRadius;
        this.type = b.type;
    }

    public static IndividualSearchBuilder<?, ?> builder() {
        return new IndividualSearchBuilderImpl();
    }

    public List<String> getIndividualId() {
        return this.individualId;
    }

    public Name getName() {
        return this.name;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public List<String> getMobileNumber() {
        return this.mobileNumber;
    }

    public String getSocialCategory() {
        return this.socialCategory;
    }

    public String getWardCode() {
        return this.wardCode;
    }

    public String getIndividualName() {
        return this.individualName;
    }

    public BigDecimal getCreatedFrom() {
        return this.createdFrom;
    }

    public BigDecimal getCreatedTo() {
        return this.createdTo;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getBoundaryCode() {
        return this.boundaryCode;
    }

    public List<String> getRoleCodes() {
        return this.roleCodes;
    }

    public List<String> getUsername() {
        return this.username;
    }

    public List<Long> getUserId() {
        return this.userId;
    }

    public List<String> getUserUuid() {
        return this.userUuid;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getSearchRadius() {
        return this.searchRadius;
    }

    public String getType() {
        return this.type;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(List<String> individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="gender")
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JsonProperty(value="mobileNumber")
    public void setMobileNumber(List<String> mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @JsonProperty(value="socialCategory")
    public void setSocialCategory(String socialCategory) {
        this.socialCategory = socialCategory;
    }

    @JsonProperty(value="wardCode")
    public void setWardCode(String wardCode) {
        this.wardCode = wardCode;
    }

    @JsonProperty(value="individualName")
    public void setIndividualName(String individualName) {
        this.individualName = individualName;
    }

    @JsonProperty(value="createdFrom")
    public void setCreatedFrom(BigDecimal createdFrom) {
        this.createdFrom = createdFrom;
    }

    @JsonProperty(value="createdTo")
    public void setCreatedTo(BigDecimal createdTo) {
        this.createdTo = createdTo;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="boundaryCode")
    public void setBoundaryCode(String boundaryCode) {
        this.boundaryCode = boundaryCode;
    }

    @JsonProperty(value="roleCodes")
    public void setRoleCodes(List<String> roleCodes) {
        this.roleCodes = roleCodes;
    }

    @JsonProperty(value="username")
    public void setUsername(List<String> username) {
        this.username = username;
    }

    @JsonProperty(value="userId")
    public void setUserId(List<Long> userId) {
        this.userId = userId;
    }

    @JsonProperty(value="userUuid")
    public void setUserUuid(List<String> userUuid) {
        this.userUuid = userUuid;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="searchRadius")
    public void setSearchRadius(Double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndividualSearch)) {
            return false;
        }
        IndividualSearch other = (IndividualSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$searchRadius = this.getSearchRadius();
        Double other$searchRadius = other.getSearchRadius();
        if (this$searchRadius == null ? other$searchRadius != null : !((Object)this$searchRadius).equals(other$searchRadius)) {
            return false;
        }
        List<String> this$individualId = this.getIndividualId();
        List<String> other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !((Object)this$individualId).equals(other$individualId)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Date this$dateOfBirth = this.getDateOfBirth();
        Date other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        List<String> this$mobileNumber = this.getMobileNumber();
        List<String> other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !((Object)this$mobileNumber).equals(other$mobileNumber)) {
            return false;
        }
        String this$socialCategory = this.getSocialCategory();
        String other$socialCategory = other.getSocialCategory();
        if (this$socialCategory == null ? other$socialCategory != null : !this$socialCategory.equals(other$socialCategory)) {
            return false;
        }
        String this$wardCode = this.getWardCode();
        String other$wardCode = other.getWardCode();
        if (this$wardCode == null ? other$wardCode != null : !this$wardCode.equals(other$wardCode)) {
            return false;
        }
        String this$individualName = this.getIndividualName();
        String other$individualName = other.getIndividualName();
        if (this$individualName == null ? other$individualName != null : !this$individualName.equals(other$individualName)) {
            return false;
        }
        BigDecimal this$createdFrom = this.getCreatedFrom();
        BigDecimal other$createdFrom = other.getCreatedFrom();
        if (this$createdFrom == null ? other$createdFrom != null : !((Object)this$createdFrom).equals(other$createdFrom)) {
            return false;
        }
        BigDecimal this$createdTo = this.getCreatedTo();
        BigDecimal other$createdTo = other.getCreatedTo();
        if (this$createdTo == null ? other$createdTo != null : !((Object)this$createdTo).equals(other$createdTo)) {
            return false;
        }
        Identifier this$identifier = this.getIdentifier();
        Identifier other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        String this$boundaryCode = this.getBoundaryCode();
        String other$boundaryCode = other.getBoundaryCode();
        if (this$boundaryCode == null ? other$boundaryCode != null : !this$boundaryCode.equals(other$boundaryCode)) {
            return false;
        }
        List<String> this$roleCodes = this.getRoleCodes();
        List<String> other$roleCodes = other.getRoleCodes();
        if (this$roleCodes == null ? other$roleCodes != null : !((Object)this$roleCodes).equals(other$roleCodes)) {
            return false;
        }
        List<String> this$username = this.getUsername();
        List<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        List<Long> this$userId = this.getUserId();
        List<Long> other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<String> this$userUuid = this.getUserUuid();
        List<String> other$userUuid = other.getUserUuid();
        if (this$userUuid == null ? other$userUuid != null : !((Object)this$userUuid).equals(other$userUuid)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IndividualSearch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $searchRadius = this.getSearchRadius();
        result = result * 59 + ($searchRadius == null ? 43 : ((Object)$searchRadius).hashCode());
        List<String> $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : ((Object)$individualId).hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Date $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        List<String> $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : ((Object)$mobileNumber).hashCode());
        String $socialCategory = this.getSocialCategory();
        result = result * 59 + ($socialCategory == null ? 43 : $socialCategory.hashCode());
        String $wardCode = this.getWardCode();
        result = result * 59 + ($wardCode == null ? 43 : $wardCode.hashCode());
        String $individualName = this.getIndividualName();
        result = result * 59 + ($individualName == null ? 43 : $individualName.hashCode());
        BigDecimal $createdFrom = this.getCreatedFrom();
        result = result * 59 + ($createdFrom == null ? 43 : ((Object)$createdFrom).hashCode());
        BigDecimal $createdTo = this.getCreatedTo();
        result = result * 59 + ($createdTo == null ? 43 : ((Object)$createdTo).hashCode());
        Identifier $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        String $boundaryCode = this.getBoundaryCode();
        result = result * 59 + ($boundaryCode == null ? 43 : $boundaryCode.hashCode());
        List<String> $roleCodes = this.getRoleCodes();
        result = result * 59 + ($roleCodes == null ? 43 : ((Object)$roleCodes).hashCode());
        List<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        List<Long> $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<String> $userUuid = this.getUserUuid();
        result = result * 59 + ($userUuid == null ? 43 : ((Object)$userUuid).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "IndividualSearch(individualId=" + this.getIndividualId() + ", name=" + this.getName() + ", dateOfBirth=" + this.getDateOfBirth() + ", gender=" + this.getGender() + ", mobileNumber=" + this.getMobileNumber() + ", socialCategory=" + this.getSocialCategory() + ", wardCode=" + this.getWardCode() + ", individualName=" + this.getIndividualName() + ", createdFrom=" + this.getCreatedFrom() + ", createdTo=" + this.getCreatedTo() + ", identifier=" + this.getIdentifier() + ", boundaryCode=" + this.getBoundaryCode() + ", roleCodes=" + this.getRoleCodes() + ", username=" + this.getUsername() + ", userId=" + this.getUserId() + ", userUuid=" + this.getUserUuid() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", searchRadius=" + this.getSearchRadius() + ", type=" + this.getType() + ")";
    }

    public IndividualSearch() {
    }

    public IndividualSearch(List<String> individualId, Name name, Date dateOfBirth, Gender gender, List<String> mobileNumber, String socialCategory, String wardCode, String individualName, BigDecimal createdFrom, BigDecimal createdTo, Identifier identifier, String boundaryCode, List<String> roleCodes, List<String> username, List<Long> userId, List<String> userUuid, Double latitude, Double longitude, Double searchRadius, String type) {
        this.individualId = individualId;
        this.name = name;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.mobileNumber = mobileNumber;
        this.socialCategory = socialCategory;
        this.wardCode = wardCode;
        this.individualName = individualName;
        this.createdFrom = createdFrom;
        this.createdTo = createdTo;
        this.identifier = identifier;
        this.boundaryCode = boundaryCode;
        this.roleCodes = roleCodes;
        this.username = username;
        this.userId = userId;
        this.userUuid = userUuid;
        this.latitude = latitude;
        this.longitude = longitude;
        this.searchRadius = searchRadius;
        this.type = type;
    }

    public static abstract class IndividualSearchBuilder<C extends IndividualSearch, B extends IndividualSearchBuilder<C, B>>
    extends EgovOfflineSearchModel.EgovOfflineSearchModelBuilder<C, B> {
        private List<String> individualId;
        private Name name;
        private Date dateOfBirth;
        private Gender gender;
        private List<String> mobileNumber;
        private String socialCategory;
        private String wardCode;
        private String individualName;
        private BigDecimal createdFrom;
        private BigDecimal createdTo;
        private Identifier identifier;
        private String boundaryCode;
        private List<String> roleCodes;
        private List<String> username;
        private List<Long> userId;
        private List<String> userUuid;
        private Double latitude;
        private Double longitude;
        private Double searchRadius;
        private String type;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="individualId")
        public B individualId(List<String> individualId) {
            this.individualId = individualId;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        public B name(Name name) {
            this.name = name;
            return (B)this.self();
        }

        @JsonProperty(value="dateOfBirth")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
        public B dateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return (B)this.self();
        }

        @JsonProperty(value="gender")
        public B gender(Gender gender) {
            this.gender = gender;
            return (B)this.self();
        }

        @JsonProperty(value="mobileNumber")
        public B mobileNumber(List<String> mobileNumber) {
            this.mobileNumber = mobileNumber;
            return (B)this.self();
        }

        @JsonProperty(value="socialCategory")
        public B socialCategory(String socialCategory) {
            this.socialCategory = socialCategory;
            return (B)this.self();
        }

        @JsonProperty(value="wardCode")
        public B wardCode(String wardCode) {
            this.wardCode = wardCode;
            return (B)this.self();
        }

        @JsonProperty(value="individualName")
        public B individualName(String individualName) {
            this.individualName = individualName;
            return (B)this.self();
        }

        @JsonProperty(value="createdFrom")
        public B createdFrom(BigDecimal createdFrom) {
            this.createdFrom = createdFrom;
            return (B)this.self();
        }

        @JsonProperty(value="createdTo")
        public B createdTo(BigDecimal createdTo) {
            this.createdTo = createdTo;
            return (B)this.self();
        }

        @JsonProperty(value="identifier")
        public B identifier(Identifier identifier) {
            this.identifier = identifier;
            return (B)this.self();
        }

        @JsonProperty(value="boundaryCode")
        public B boundaryCode(String boundaryCode) {
            this.boundaryCode = boundaryCode;
            return (B)this.self();
        }

        @JsonProperty(value="roleCodes")
        public B roleCodes(List<String> roleCodes) {
            this.roleCodes = roleCodes;
            return (B)this.self();
        }

        @JsonProperty(value="username")
        public B username(List<String> username) {
            this.username = username;
            return (B)this.self();
        }

        @JsonProperty(value="userId")
        public B userId(List<Long> userId) {
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="userUuid")
        public B userUuid(List<String> userUuid) {
            this.userUuid = userUuid;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(Double latitude) {
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(Double longitude) {
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="searchRadius")
        public B searchRadius(Double searchRadius) {
            this.searchRadius = searchRadius;
            return (B)this.self();
        }

        @JsonProperty(value="type")
        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "IndividualSearch.IndividualSearchBuilder(super=" + super.toString() + ", individualId=" + this.individualId + ", name=" + this.name + ", dateOfBirth=" + this.dateOfBirth + ", gender=" + this.gender + ", mobileNumber=" + this.mobileNumber + ", socialCategory=" + this.socialCategory + ", wardCode=" + this.wardCode + ", individualName=" + this.individualName + ", createdFrom=" + this.createdFrom + ", createdTo=" + this.createdTo + ", identifier=" + this.identifier + ", boundaryCode=" + this.boundaryCode + ", roleCodes=" + this.roleCodes + ", username=" + this.username + ", userId=" + this.userId + ", userUuid=" + this.userUuid + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", searchRadius=" + this.searchRadius + ", type=" + this.type + ")";
        }
    }

    private static final class IndividualSearchBuilderImpl
    extends IndividualSearchBuilder<IndividualSearch, IndividualSearchBuilderImpl> {
        private IndividualSearchBuilderImpl() {
        }

        @Override
        protected IndividualSearchBuilderImpl self() {
            return this;
        }

        @Override
        public IndividualSearch build() {
            return new IndividualSearch(this);
        }
    }
}

