/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.core.validator;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.egov.tracer.model.CustomException;

public class CustomIntegerDeserializer
extends StdDeserializer<Integer> {
    public CustomIntegerDeserializer() {
        this(null);
    }

    public CustomIntegerDeserializer(Class<?> vc) {
        super(vc);
    }

    public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        System.out.println(node.toString());
        if (node.asLong() > Integer.MAX_VALUE) {
            throw new CustomException("INVALID_INPUT", "Value must be an Integer");
        }
        int quantity = node.asInt();
        if ((double)quantity != Double.parseDouble(node.asText())) {
            throw new CustomException("INVALID_INPUT", "Quantity must be an integer");
        }
        return quantity;
    }
}

