/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement.sideeffect;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.referralmanagement.sideeffect.SideEffect;

public class SideEffectBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo;
    @JsonProperty(value="SideEffects")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<SideEffect> sideEffects = new ArrayList<SideEffect>();

    public SideEffectBulkRequest addSideEffectItem(SideEffect sideEffectItem) {
        if (Objects.isNull(this.sideEffects)) {
            this.sideEffects = new ArrayList<SideEffect>();
        }
        if (Objects.nonNull(sideEffectItem)) {
            this.sideEffects.add(sideEffectItem);
        }
        return this;
    }

    public static SideEffectBulkRequestBuilder builder() {
        return new SideEffectBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<SideEffect> getSideEffects() {
        return this.sideEffects;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="SideEffects")
    public void setSideEffects(List<SideEffect> sideEffects) {
        this.sideEffects = sideEffects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SideEffectBulkRequest)) {
            return false;
        }
        SideEffectBulkRequest other = (SideEffectBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<SideEffect> this$sideEffects = this.getSideEffects();
        List<SideEffect> other$sideEffects = other.getSideEffects();
        return !(this$sideEffects == null ? other$sideEffects != null : !((Object)this$sideEffects).equals(other$sideEffects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SideEffectBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<SideEffect> $sideEffects = this.getSideEffects();
        result = result * 59 + ($sideEffects == null ? 43 : ((Object)$sideEffects).hashCode());
        return result;
    }

    public String toString() {
        return "SideEffectBulkRequest(requestInfo=" + this.getRequestInfo() + ", sideEffects=" + this.getSideEffects() + ")";
    }

    public SideEffectBulkRequest() {
    }

    public SideEffectBulkRequest(RequestInfo requestInfo, List<SideEffect> sideEffects) {
        this.requestInfo = requestInfo;
        this.sideEffects = sideEffects;
    }

    public static class SideEffectBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<SideEffect> sideEffects;

        SideEffectBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public SideEffectBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="SideEffects")
        public SideEffectBulkRequestBuilder sideEffects(List<SideEffect> sideEffects) {
            this.sideEffects = sideEffects;
            return this;
        }

        public SideEffectBulkRequest build() {
            return new SideEffectBulkRequest(this.requestInfo, this.sideEffects);
        }

        public String toString() {
            return "SideEffectBulkRequest.SideEffectBulkRequestBuilder(requestInfo=" + this.requestInfo + ", sideEffects=" + this.sideEffects + ")";
        }
    }
}

