/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResourceRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectResource")
    @NotNull
    @Valid
    private ProjectResource projectResource = null;

    public static ProjectResourceRequestBuilder builder() {
        return new ProjectResourceRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public ProjectResource getProjectResource() {
        return this.projectResource;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectResource")
    public void setProjectResource(ProjectResource projectResource) {
        this.projectResource = projectResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResourceRequest)) {
            return false;
        }
        ProjectResourceRequest other = (ProjectResourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        ProjectResource this$projectResource = this.getProjectResource();
        ProjectResource other$projectResource = other.getProjectResource();
        return !(this$projectResource == null ? other$projectResource != null : !((Object)this$projectResource).equals(other$projectResource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectResourceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        ProjectResource $projectResource = this.getProjectResource();
        result = result * 59 + ($projectResource == null ? 43 : ((Object)$projectResource).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectResourceRequest(requestInfo=" + this.getRequestInfo() + ", projectResource=" + this.getProjectResource() + ")";
    }

    public ProjectResourceRequest() {
    }

    public ProjectResourceRequest(RequestInfo requestInfo, ProjectResource projectResource) {
        this.requestInfo = requestInfo;
        this.projectResource = projectResource;
    }

    public static class ProjectResourceRequestBuilder {
        private RequestInfo requestInfo;
        private ProjectResource projectResource;

        ProjectResourceRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectResourceRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectResource")
        public ProjectResourceRequestBuilder projectResource(ProjectResource projectResource) {
            this.projectResource = projectResource;
            return this;
        }

        public ProjectResourceRequest build() {
            return new ProjectResourceRequest(this.requestInfo, this.projectResource);
        }

        public String toString() {
            return "ProjectResourceRequest.ProjectResourceRequestBuilder(requestInfo=" + this.requestInfo + ", projectResource=" + this.projectResource + ")";
        }
    }
}

