/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.stock.StockSearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockSearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    private StockSearch stock = null;

    public static StockSearchRequestBuilder builder() {
        return new StockSearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public StockSearch getStock() {
        return this.stock;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(StockSearch stock) {
        this.stock = stock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockSearchRequest)) {
            return false;
        }
        StockSearchRequest other = (StockSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        StockSearch this$stock = this.getStock();
        StockSearch other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        StockSearch $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockSearchRequest(requestInfo=" + this.getRequestInfo() + ", stock=" + this.getStock() + ")";
    }

    public StockSearchRequest() {
    }

    public StockSearchRequest(RequestInfo requestInfo, StockSearch stock) {
        this.requestInfo = requestInfo;
        this.stock = stock;
    }

    public static class StockSearchRequestBuilder {
        private RequestInfo requestInfo;
        private StockSearch stock;

        StockSearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public StockSearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockSearchRequestBuilder stock(StockSearch stock) {
            this.stock = stock;
            return this;
        }

        public StockSearchRequest build() {
            return new StockSearchRequest(this.requestInfo, this.stock);
        }

        public String toString() {
            return "StockSearchRequest.StockSearchRequestBuilder(requestInfo=" + this.requestInfo + ", stock=" + this.stock + ")";
        }
    }
}

