/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.stock.StockReconciliation;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockReconciliationBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="StockReconciliation")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<StockReconciliation> stockReconciliation = new ArrayList<StockReconciliation>();

    public StockReconciliationBulkRequest addStockReconciliationItem(StockReconciliation stockReconciliationItem) {
        this.stockReconciliation.add(stockReconciliationItem);
        return this;
    }

    public static StockReconciliationBulkRequestBuilder builder() {
        return new StockReconciliationBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<StockReconciliation> getStockReconciliation() {
        return this.stockReconciliation;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="StockReconciliation")
    public void setStockReconciliation(List<StockReconciliation> stockReconciliation) {
        this.stockReconciliation = stockReconciliation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockReconciliationBulkRequest)) {
            return false;
        }
        StockReconciliationBulkRequest other = (StockReconciliationBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<StockReconciliation> this$stockReconciliation = this.getStockReconciliation();
        List<StockReconciliation> other$stockReconciliation = other.getStockReconciliation();
        return !(this$stockReconciliation == null ? other$stockReconciliation != null : !((Object)this$stockReconciliation).equals(other$stockReconciliation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockReconciliationBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<StockReconciliation> $stockReconciliation = this.getStockReconciliation();
        result = result * 59 + ($stockReconciliation == null ? 43 : ((Object)$stockReconciliation).hashCode());
        return result;
    }

    public String toString() {
        return "StockReconciliationBulkRequest(requestInfo=" + this.getRequestInfo() + ", stockReconciliation=" + this.getStockReconciliation() + ")";
    }

    public StockReconciliationBulkRequest() {
    }

    public StockReconciliationBulkRequest(RequestInfo requestInfo, List<StockReconciliation> stockReconciliation) {
        this.requestInfo = requestInfo;
        this.stockReconciliation = stockReconciliation;
    }

    public static class StockReconciliationBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<StockReconciliation> stockReconciliation;

        StockReconciliationBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public StockReconciliationBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="StockReconciliation")
        public StockReconciliationBulkRequestBuilder stockReconciliation(List<StockReconciliation> stockReconciliation) {
            this.stockReconciliation = stockReconciliation;
            return this;
        }

        public StockReconciliationBulkRequest build() {
            return new StockReconciliationBulkRequest(this.requestInfo, this.stockReconciliation);
        }

        public String toString() {
            return "StockReconciliationBulkRequest.StockReconciliationBulkRequestBuilder(requestInfo=" + this.requestInfo + ", stockReconciliation=" + this.stockReconciliation + ")";
        }
    }
}

