/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.project.Address;
import org.egov.common.models.project.TaskResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends EgovOfflineModel {
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="projectBeneficiaryId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectBeneficiaryId = null;
    @JsonProperty(value="projectBeneficiaryClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectBeneficiaryClientReferenceId = null;
    @JsonProperty(value="resources")
    @Valid
    private List<TaskResource> resources;
    @JsonProperty(value="plannedStartDate")
    private Long plannedStartDate = null;
    @JsonProperty(value="plannedEndDate")
    private Long plannedEndDate = null;
    @JsonProperty(value="actualStartDate")
    private Long actualStartDate = null;
    @JsonProperty(value="actualEndDate")
    private Long actualEndDate = null;
    @JsonProperty(value="createdBy")
    private String createdBy = null;
    @JsonProperty(value="createdDate")
    private Long createdDate = null;
    @JsonProperty(value="address")
    @Valid
    private Address address = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="status")
    private String status = null;

    public Task addResourcesItem(TaskResource resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    private static List<TaskResource> $default$resources() {
        return new ArrayList<TaskResource>();
    }

    protected Task(TaskBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.projectId = b.projectId;
        this.projectBeneficiaryId = b.projectBeneficiaryId;
        this.projectBeneficiaryClientReferenceId = b.projectBeneficiaryClientReferenceId;
        this.resources = b.resources$set ? b.resources$value : Task.$default$resources();
        this.plannedStartDate = b.plannedStartDate;
        this.plannedEndDate = b.plannedEndDate;
        this.actualStartDate = b.actualStartDate;
        this.actualEndDate = b.actualEndDate;
        this.createdBy = b.createdBy;
        this.createdDate = b.createdDate;
        this.address = b.address;
        this.isDeleted = b.isDeleted;
        this.status = b.status;
    }

    public static TaskBuilder<?, ?> builder() {
        return new TaskBuilderImpl();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectBeneficiaryId() {
        return this.projectBeneficiaryId;
    }

    public String getProjectBeneficiaryClientReferenceId() {
        return this.projectBeneficiaryClientReferenceId;
    }

    public List<TaskResource> getResources() {
        return this.resources;
    }

    public Long getPlannedStartDate() {
        return this.plannedStartDate;
    }

    public Long getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public Long getActualStartDate() {
        return this.actualStartDate;
    }

    public Long getActualEndDate() {
        return this.actualEndDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Address getAddress() {
        return this.address;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="projectBeneficiaryId")
    public void setProjectBeneficiaryId(String projectBeneficiaryId) {
        this.projectBeneficiaryId = projectBeneficiaryId;
    }

    @JsonProperty(value="projectBeneficiaryClientReferenceId")
    public void setProjectBeneficiaryClientReferenceId(String projectBeneficiaryClientReferenceId) {
        this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
    }

    @JsonProperty(value="resources")
    public void setResources(List<TaskResource> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="plannedStartDate")
    public void setPlannedStartDate(Long plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    @JsonProperty(value="plannedEndDate")
    public void setPlannedEndDate(Long plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @JsonProperty(value="actualStartDate")
    public void setActualStartDate(Long actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    @JsonProperty(value="actualEndDate")
    public void setActualEndDate(Long actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="createdDate")
    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$plannedStartDate = this.getPlannedStartDate();
        Long other$plannedStartDate = other.getPlannedStartDate();
        if (this$plannedStartDate == null ? other$plannedStartDate != null : !((Object)this$plannedStartDate).equals(other$plannedStartDate)) {
            return false;
        }
        Long this$plannedEndDate = this.getPlannedEndDate();
        Long other$plannedEndDate = other.getPlannedEndDate();
        if (this$plannedEndDate == null ? other$plannedEndDate != null : !((Object)this$plannedEndDate).equals(other$plannedEndDate)) {
            return false;
        }
        Long this$actualStartDate = this.getActualStartDate();
        Long other$actualStartDate = other.getActualStartDate();
        if (this$actualStartDate == null ? other$actualStartDate != null : !((Object)this$actualStartDate).equals(other$actualStartDate)) {
            return false;
        }
        Long this$actualEndDate = this.getActualEndDate();
        Long other$actualEndDate = other.getActualEndDate();
        if (this$actualEndDate == null ? other$actualEndDate != null : !((Object)this$actualEndDate).equals(other$actualEndDate)) {
            return false;
        }
        Long this$createdDate = this.getCreatedDate();
        Long other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectBeneficiaryId = this.getProjectBeneficiaryId();
        String other$projectBeneficiaryId = other.getProjectBeneficiaryId();
        if (this$projectBeneficiaryId == null ? other$projectBeneficiaryId != null : !this$projectBeneficiaryId.equals(other$projectBeneficiaryId)) {
            return false;
        }
        String this$projectBeneficiaryClientReferenceId = this.getProjectBeneficiaryClientReferenceId();
        String other$projectBeneficiaryClientReferenceId = other.getProjectBeneficiaryClientReferenceId();
        if (this$projectBeneficiaryClientReferenceId == null ? other$projectBeneficiaryClientReferenceId != null : !this$projectBeneficiaryClientReferenceId.equals(other$projectBeneficiaryClientReferenceId)) {
            return false;
        }
        List<TaskResource> this$resources = this.getResources();
        List<TaskResource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $plannedStartDate = this.getPlannedStartDate();
        result = result * 59 + ($plannedStartDate == null ? 43 : ((Object)$plannedStartDate).hashCode());
        Long $plannedEndDate = this.getPlannedEndDate();
        result = result * 59 + ($plannedEndDate == null ? 43 : ((Object)$plannedEndDate).hashCode());
        Long $actualStartDate = this.getActualStartDate();
        result = result * 59 + ($actualStartDate == null ? 43 : ((Object)$actualStartDate).hashCode());
        Long $actualEndDate = this.getActualEndDate();
        result = result * 59 + ($actualEndDate == null ? 43 : ((Object)$actualEndDate).hashCode());
        Long $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectBeneficiaryId = this.getProjectBeneficiaryId();
        result = result * 59 + ($projectBeneficiaryId == null ? 43 : $projectBeneficiaryId.hashCode());
        String $projectBeneficiaryClientReferenceId = this.getProjectBeneficiaryClientReferenceId();
        result = result * 59 + ($projectBeneficiaryClientReferenceId == null ? 43 : $projectBeneficiaryClientReferenceId.hashCode());
        List<TaskResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Task(projectId=" + this.getProjectId() + ", projectBeneficiaryId=" + this.getProjectBeneficiaryId() + ", projectBeneficiaryClientReferenceId=" + this.getProjectBeneficiaryClientReferenceId() + ", resources=" + this.getResources() + ", plannedStartDate=" + this.getPlannedStartDate() + ", plannedEndDate=" + this.getPlannedEndDate() + ", actualStartDate=" + this.getActualStartDate() + ", actualEndDate=" + this.getActualEndDate() + ", createdBy=" + this.getCreatedBy() + ", createdDate=" + this.getCreatedDate() + ", address=" + this.getAddress() + ", isDeleted=" + this.getIsDeleted() + ", status=" + this.getStatus() + ")";
    }

    public Task() {
        this.resources = Task.$default$resources();
    }

    public Task(String projectId, String projectBeneficiaryId, String projectBeneficiaryClientReferenceId, List<TaskResource> resources, Long plannedStartDate, Long plannedEndDate, Long actualStartDate, Long actualEndDate, String createdBy, Long createdDate, Address address, Boolean isDeleted, String status) {
        this.projectId = projectId;
        this.projectBeneficiaryId = projectBeneficiaryId;
        this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
        this.resources = resources;
        this.plannedStartDate = plannedStartDate;
        this.plannedEndDate = plannedEndDate;
        this.actualStartDate = actualStartDate;
        this.actualEndDate = actualEndDate;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.address = address;
        this.isDeleted = isDeleted;
        this.status = status;
    }

    public static abstract class TaskBuilder<C extends Task, B extends TaskBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String projectId;
        private String projectBeneficiaryId;
        private String projectBeneficiaryClientReferenceId;
        private boolean resources$set;
        private List<TaskResource> resources$value;
        private Long plannedStartDate;
        private Long plannedEndDate;
        private Long actualStartDate;
        private Long actualEndDate;
        private String createdBy;
        private Long createdDate;
        private Address address;
        private Boolean isDeleted;
        private String status;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="projectBeneficiaryId")
        public B projectBeneficiaryId(String projectBeneficiaryId) {
            this.projectBeneficiaryId = projectBeneficiaryId;
            return (B)this.self();
        }

        @JsonProperty(value="projectBeneficiaryClientReferenceId")
        public B projectBeneficiaryClientReferenceId(String projectBeneficiaryClientReferenceId) {
            this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
            return (B)this.self();
        }

        @JsonProperty(value="resources")
        public B resources(List<TaskResource> resources) {
            this.resources$value = resources;
            this.resources$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="plannedStartDate")
        public B plannedStartDate(Long plannedStartDate) {
            this.plannedStartDate = plannedStartDate;
            return (B)this.self();
        }

        @JsonProperty(value="plannedEndDate")
        public B plannedEndDate(Long plannedEndDate) {
            this.plannedEndDate = plannedEndDate;
            return (B)this.self();
        }

        @JsonProperty(value="actualStartDate")
        public B actualStartDate(Long actualStartDate) {
            this.actualStartDate = actualStartDate;
            return (B)this.self();
        }

        @JsonProperty(value="actualEndDate")
        public B actualEndDate(Long actualEndDate) {
            this.actualEndDate = actualEndDate;
            return (B)this.self();
        }

        @JsonProperty(value="createdBy")
        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @JsonProperty(value="createdDate")
        public B createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return (B)this.self();
        }

        @JsonProperty(value="address")
        public B address(Address address) {
            this.address = address;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        @JsonProperty(value="status")
        public B status(String status) {
            this.status = status;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Task.TaskBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", projectBeneficiaryId=" + this.projectBeneficiaryId + ", projectBeneficiaryClientReferenceId=" + this.projectBeneficiaryClientReferenceId + ", resources$value=" + this.resources$value + ", plannedStartDate=" + this.plannedStartDate + ", plannedEndDate=" + this.plannedEndDate + ", actualStartDate=" + this.actualStartDate + ", actualEndDate=" + this.actualEndDate + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", address=" + this.address + ", isDeleted=" + this.isDeleted + ", status=" + this.status + ")";
        }
    }

    private static final class TaskBuilderImpl
    extends TaskBuilder<Task, TaskBuilderImpl> {
        private TaskBuilderImpl() {
        }

        @Override
        protected TaskBuilderImpl self() {
            return this;
        }

        @Override
        public Task build() {
            return new Task(this);
        }
    }
}

