/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovModel;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This object defines the mapping of a facility to a project.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectFacility
extends EgovModel {
    @JsonProperty(value="facilityId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String facilityId = null;
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;

    protected ProjectFacility(ProjectFacilityBuilder<?, ?> b) {
        super(b);
        this.facilityId = b.facilityId;
        this.projectId = b.projectId;
        this.isDeleted = b.isDeleted;
    }

    public static ProjectFacilityBuilder<?, ?> builder() {
        return new ProjectFacilityBuilderImpl();
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="facilityId")
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFacility)) {
            return false;
        }
        ProjectFacility other = (ProjectFacility)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$facilityId = this.getFacilityId();
        String other$facilityId = other.getFacilityId();
        if (this$facilityId == null ? other$facilityId != null : !this$facilityId.equals(other$facilityId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        return !(this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectFacility;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $facilityId = this.getFacilityId();
        result = result * 59 + ($facilityId == null ? 43 : $facilityId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectFacility(facilityId=" + this.getFacilityId() + ", projectId=" + this.getProjectId() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public ProjectFacility() {
    }

    public ProjectFacility(String facilityId, String projectId, Boolean isDeleted) {
        this.facilityId = facilityId;
        this.projectId = projectId;
        this.isDeleted = isDeleted;
    }

    public static abstract class ProjectFacilityBuilder<C extends ProjectFacility, B extends ProjectFacilityBuilder<C, B>>
    extends EgovModel.EgovModelBuilder<C, B> {
        private String facilityId;
        private String projectId;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="facilityId")
        public B facilityId(String facilityId) {
            this.facilityId = facilityId;
            return (B)this.self();
        }

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProjectFacility.ProjectFacilityBuilder(super=" + super.toString() + ", facilityId=" + this.facilityId + ", projectId=" + this.projectId + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class ProjectFacilityBuilderImpl
    extends ProjectFacilityBuilder<ProjectFacility, ProjectFacilityBuilderImpl> {
        private ProjectFacilityBuilderImpl() {
        }

        @Override
        protected ProjectFacilityBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectFacility build() {
            return new ProjectFacility(this);
        }
    }
}

