/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.stock.StockReconciliation;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockReconciliationBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="StockReconciliation")
    @NotNull
    @Valid
    private List<StockReconciliation> stockReconciliation = new ArrayList<StockReconciliation>();

    public StockReconciliationBulkResponse addStockReconciliationItem(StockReconciliation stockReconciliationItem) {
        this.stockReconciliation.add(stockReconciliationItem);
        return this;
    }

    public static StockReconciliationBulkResponseBuilder builder() {
        return new StockReconciliationBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<StockReconciliation> getStockReconciliation() {
        return this.stockReconciliation;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="StockReconciliation")
    public void setStockReconciliation(List<StockReconciliation> stockReconciliation) {
        this.stockReconciliation = stockReconciliation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockReconciliationBulkResponse)) {
            return false;
        }
        StockReconciliationBulkResponse other = (StockReconciliationBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<StockReconciliation> this$stockReconciliation = this.getStockReconciliation();
        List<StockReconciliation> other$stockReconciliation = other.getStockReconciliation();
        return !(this$stockReconciliation == null ? other$stockReconciliation != null : !((Object)this$stockReconciliation).equals(other$stockReconciliation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockReconciliationBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<StockReconciliation> $stockReconciliation = this.getStockReconciliation();
        result = result * 59 + ($stockReconciliation == null ? 43 : ((Object)$stockReconciliation).hashCode());
        return result;
    }

    public String toString() {
        return "StockReconciliationBulkResponse(responseInfo=" + this.getResponseInfo() + ", stockReconciliation=" + this.getStockReconciliation() + ")";
    }

    public StockReconciliationBulkResponse() {
    }

    public StockReconciliationBulkResponse(ResponseInfo responseInfo, List<StockReconciliation> stockReconciliation) {
        this.responseInfo = responseInfo;
        this.stockReconciliation = stockReconciliation;
    }

    public static class StockReconciliationBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<StockReconciliation> stockReconciliation;

        StockReconciliationBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public StockReconciliationBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="StockReconciliation")
        public StockReconciliationBulkResponseBuilder stockReconciliation(List<StockReconciliation> stockReconciliation) {
            this.stockReconciliation = stockReconciliation;
            return this;
        }

        public StockReconciliationBulkResponse build() {
            return new StockReconciliationBulkResponse(this.responseInfo, this.stockReconciliation);
        }

        public String toString() {
            return "StockReconciliationBulkResponse.StockReconciliationBulkResponseBuilder(responseInfo=" + this.responseInfo + ", stockReconciliation=" + this.stockReconciliation + ")";
        }
    }
}

