/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.ProjectFacility;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectFacilityBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="ProjectFacilities")
    @NotNull
    @Valid
    private List<ProjectFacility> projectFacilities = new ArrayList<ProjectFacility>();

    public ProjectFacilityBulkResponse addProjectFacilityItem(ProjectFacility projectFacilityItem) {
        this.projectFacilities.add(projectFacilityItem);
        return this;
    }

    public static ProjectFacilityBulkResponseBuilder builder() {
        return new ProjectFacilityBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<ProjectFacility> getProjectFacilities() {
        return this.projectFacilities;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="ProjectFacilities")
    public void setProjectFacilities(List<ProjectFacility> projectFacilities) {
        this.projectFacilities = projectFacilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFacilityBulkResponse)) {
            return false;
        }
        ProjectFacilityBulkResponse other = (ProjectFacilityBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<ProjectFacility> this$projectFacilities = this.getProjectFacilities();
        List<ProjectFacility> other$projectFacilities = other.getProjectFacilities();
        return !(this$projectFacilities == null ? other$projectFacilities != null : !((Object)this$projectFacilities).equals(other$projectFacilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectFacilityBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<ProjectFacility> $projectFacilities = this.getProjectFacilities();
        result = result * 59 + ($projectFacilities == null ? 43 : ((Object)$projectFacilities).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectFacilityBulkResponse(responseInfo=" + this.getResponseInfo() + ", projectFacilities=" + this.getProjectFacilities() + ")";
    }

    public ProjectFacilityBulkResponse() {
    }

    public ProjectFacilityBulkResponse(ResponseInfo responseInfo, List<ProjectFacility> projectFacilities) {
        this.responseInfo = responseInfo;
        this.projectFacilities = projectFacilities;
    }

    public static class ProjectFacilityBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<ProjectFacility> projectFacilities;

        ProjectFacilityBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProjectFacilityBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="ProjectFacilities")
        public ProjectFacilityBulkResponseBuilder projectFacilities(List<ProjectFacility> projectFacilities) {
            this.projectFacilities = projectFacilities;
            return this;
        }

        public ProjectFacilityBulkResponse build() {
            return new ProjectFacilityBulkResponse(this.responseInfo, this.projectFacilities);
        }

        public String toString() {
            return "ProjectFacilityBulkResponse.ProjectFacilityBulkResponseBuilder(responseInfo=" + this.responseInfo + ", projectFacilities=" + this.projectFacilities + ")";
        }
    }
}

