/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.facility;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.facility.FacilitySearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class FacilitySearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Facility")
    @NotNull
    @Valid
    private FacilitySearch facility = null;

    public static FacilitySearchRequestBuilder builder() {
        return new FacilitySearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public FacilitySearch getFacility() {
        return this.facility;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Facility")
    public void setFacility(FacilitySearch facility) {
        this.facility = facility;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacilitySearchRequest)) {
            return false;
        }
        FacilitySearchRequest other = (FacilitySearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        FacilitySearch this$facility = this.getFacility();
        FacilitySearch other$facility = other.getFacility();
        return !(this$facility == null ? other$facility != null : !((Object)this$facility).equals(other$facility));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FacilitySearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        FacilitySearch $facility = this.getFacility();
        result = result * 59 + ($facility == null ? 43 : ((Object)$facility).hashCode());
        return result;
    }

    public String toString() {
        return "FacilitySearchRequest(requestInfo=" + this.getRequestInfo() + ", facility=" + this.getFacility() + ")";
    }

    public FacilitySearchRequest() {
    }

    public FacilitySearchRequest(RequestInfo requestInfo, FacilitySearch facility) {
        this.requestInfo = requestInfo;
        this.facility = facility;
    }

    public static class FacilitySearchRequestBuilder {
        private RequestInfo requestInfo;
        private FacilitySearch facility;

        FacilitySearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public FacilitySearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Facility")
        public FacilitySearchRequestBuilder facility(FacilitySearch facility) {
            this.facility = facility;
            return this;
        }

        public FacilitySearchRequest build() {
            return new FacilitySearchRequest(this.requestInfo, this.facility);
        }

        public String toString() {
            return "FacilitySearchRequest.FacilitySearchRequestBuilder(requestInfo=" + this.requestInfo + ", facility=" + this.facility + ")";
        }
    }
}

