/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.models.project.ProjectProductVariant;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This is the master data to capture the metadata of Project")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectType {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="name")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String name = null;
    @JsonProperty(value="code")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String code = null;
    @JsonProperty(value="group")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String group = null;
    @JsonProperty(value="beneficiaryType")
    private String beneficiaryType = null;
    @JsonProperty(value="eligibilityCriteria")
    @Size(max=10)
    private @Size(max=10) List<String> eligibilityCriteria = null;
    @JsonProperty(value="taskProcedure")
    @Size(max=10)
    private @Size(max=10) List<String> taskProcedure = null;
    @JsonProperty(value="resources")
    @Valid
    private List<ProjectProductVariant> resources = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public ProjectType addEligibilityCriteriaItem(String eligibilityCriteriaItem) {
        if (this.eligibilityCriteria == null) {
            this.eligibilityCriteria = new ArrayList<String>();
        }
        this.eligibilityCriteria.add(eligibilityCriteriaItem);
        return this;
    }

    public ProjectType addTaskProcedureItem(String taskProcedureItem) {
        if (this.taskProcedure == null) {
            this.taskProcedure = new ArrayList<String>();
        }
        this.taskProcedure.add(taskProcedureItem);
        return this;
    }

    public ProjectType addResourcesItem(ProjectProductVariant resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<ProjectProductVariant>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public static ProjectTypeBuilder builder() {
        return new ProjectTypeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getGroup() {
        return this.group;
    }

    public String getBeneficiaryType() {
        return this.beneficiaryType;
    }

    public List<String> getEligibilityCriteria() {
        return this.eligibilityCriteria;
    }

    public List<String> getTaskProcedure() {
        return this.taskProcedure;
    }

    public List<ProjectProductVariant> getResources() {
        return this.resources;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(value="beneficiaryType")
    public void setBeneficiaryType(String beneficiaryType) {
        this.beneficiaryType = beneficiaryType;
    }

    @JsonProperty(value="eligibilityCriteria")
    public void setEligibilityCriteria(List<String> eligibilityCriteria) {
        this.eligibilityCriteria = eligibilityCriteria;
    }

    @JsonProperty(value="taskProcedure")
    public void setTaskProcedure(List<String> taskProcedure) {
        this.taskProcedure = taskProcedure;
    }

    @JsonProperty(value="resources")
    public void setResources(List<ProjectProductVariant> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectType)) {
            return false;
        }
        ProjectType other = (ProjectType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$beneficiaryType = this.getBeneficiaryType();
        String other$beneficiaryType = other.getBeneficiaryType();
        if (this$beneficiaryType == null ? other$beneficiaryType != null : !this$beneficiaryType.equals(other$beneficiaryType)) {
            return false;
        }
        List<String> this$eligibilityCriteria = this.getEligibilityCriteria();
        List<String> other$eligibilityCriteria = other.getEligibilityCriteria();
        if (this$eligibilityCriteria == null ? other$eligibilityCriteria != null : !((Object)this$eligibilityCriteria).equals(other$eligibilityCriteria)) {
            return false;
        }
        List<String> this$taskProcedure = this.getTaskProcedure();
        List<String> other$taskProcedure = other.getTaskProcedure();
        if (this$taskProcedure == null ? other$taskProcedure != null : !((Object)this$taskProcedure).equals(other$taskProcedure)) {
            return false;
        }
        List<ProjectProductVariant> this$resources = this.getResources();
        List<ProjectProductVariant> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $beneficiaryType = this.getBeneficiaryType();
        result = result * 59 + ($beneficiaryType == null ? 43 : $beneficiaryType.hashCode());
        List<String> $eligibilityCriteria = this.getEligibilityCriteria();
        result = result * 59 + ($eligibilityCriteria == null ? 43 : ((Object)$eligibilityCriteria).hashCode());
        List<String> $taskProcedure = this.getTaskProcedure();
        result = result * 59 + ($taskProcedure == null ? 43 : ((Object)$taskProcedure).hashCode());
        List<ProjectProductVariant> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectType(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", code=" + this.getCode() + ", group=" + this.getGroup() + ", beneficiaryType=" + this.getBeneficiaryType() + ", eligibilityCriteria=" + this.getEligibilityCriteria() + ", taskProcedure=" + this.getTaskProcedure() + ", resources=" + this.getResources() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public ProjectType() {
    }

    public ProjectType(String id, String tenantId, String name, String code, String group, String beneficiaryType, List<String> eligibilityCriteria, List<String> taskProcedure, List<ProjectProductVariant> resources, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.code = code;
        this.group = group;
        this.beneficiaryType = beneficiaryType;
        this.eligibilityCriteria = eligibilityCriteria;
        this.taskProcedure = taskProcedure;
        this.resources = resources;
        this.auditDetails = auditDetails;
    }

    public static class ProjectTypeBuilder {
        private String id;
        private String tenantId;
        private String name;
        private String code;
        private String group;
        private String beneficiaryType;
        private List<String> eligibilityCriteria;
        private List<String> taskProcedure;
        private List<ProjectProductVariant> resources;
        private AuditDetails auditDetails;

        ProjectTypeBuilder() {
        }

        @JsonProperty(value="id")
        public ProjectTypeBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProjectTypeBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="name")
        public ProjectTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="code")
        public ProjectTypeBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonProperty(value="group")
        public ProjectTypeBuilder group(String group) {
            this.group = group;
            return this;
        }

        @JsonProperty(value="beneficiaryType")
        public ProjectTypeBuilder beneficiaryType(String beneficiaryType) {
            this.beneficiaryType = beneficiaryType;
            return this;
        }

        @JsonProperty(value="eligibilityCriteria")
        public ProjectTypeBuilder eligibilityCriteria(List<String> eligibilityCriteria) {
            this.eligibilityCriteria = eligibilityCriteria;
            return this;
        }

        @JsonProperty(value="taskProcedure")
        public ProjectTypeBuilder taskProcedure(List<String> taskProcedure) {
            this.taskProcedure = taskProcedure;
            return this;
        }

        @JsonProperty(value="resources")
        public ProjectTypeBuilder resources(List<ProjectProductVariant> resources) {
            this.resources = resources;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ProjectTypeBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public ProjectType build() {
            return new ProjectType(this.id, this.tenantId, this.name, this.code, this.group, this.beneficiaryType, this.eligibilityCriteria, this.taskProcedure, this.resources, this.auditDetails);
        }

        public String toString() {
            return "ProjectType.ProjectTypeBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", name=" + this.name + ", code=" + this.code + ", group=" + this.group + ", beneficiaryType=" + this.beneficiaryType + ", eligibilityCriteria=" + this.eligibilityCriteria + ", taskProcedure=" + this.taskProcedure + ", resources=" + this.resources + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

