/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import org.egov.common.models.core.EgovOfflineSearchModel;
import org.egov.common.models.core.Exclude;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdSearch
extends EgovOfflineSearchModel {
    @JsonProperty(value="boundaryCode")
    private String localityCode = null;
    @Exclude
    @JsonProperty(value="latitude")
    @DecimalMin(value="-90")
    @DecimalMax(value="90")
    private @DecimalMin(value="-90") @DecimalMax(value="90") Double latitude = null;
    @Exclude
    @JsonProperty(value="longitude")
    @DecimalMin(value="-180")
    @DecimalMax(value="180")
    private @DecimalMin(value="-180") @DecimalMax(value="180") Double longitude = null;
    @Exclude
    @JsonProperty(value="searchRadius")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Double searchRadius = null;

    protected HouseholdSearch(HouseholdSearchBuilder<?, ?> b) {
        super((EgovOfflineSearchModel.EgovOfflineSearchModelBuilder<?, ?>)b);
        this.localityCode = b.localityCode;
        this.latitude = b.latitude;
        this.longitude = b.longitude;
        this.searchRadius = b.searchRadius;
    }

    public static HouseholdSearchBuilder<?, ?> builder() {
        return new HouseholdSearchBuilderImpl();
    }

    public String getLocalityCode() {
        return this.localityCode;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getSearchRadius() {
        return this.searchRadius;
    }

    @JsonProperty(value="boundaryCode")
    public void setLocalityCode(String localityCode) {
        this.localityCode = localityCode;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="searchRadius")
    public void setSearchRadius(Double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdSearch)) {
            return false;
        }
        HouseholdSearch other = (HouseholdSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$searchRadius = this.getSearchRadius();
        Double other$searchRadius = other.getSearchRadius();
        if (this$searchRadius == null ? other$searchRadius != null : !((Object)this$searchRadius).equals(other$searchRadius)) {
            return false;
        }
        String this$localityCode = this.getLocalityCode();
        String other$localityCode = other.getLocalityCode();
        return !(this$localityCode == null ? other$localityCode != null : !this$localityCode.equals(other$localityCode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HouseholdSearch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $searchRadius = this.getSearchRadius();
        result = result * 59 + ($searchRadius == null ? 43 : ((Object)$searchRadius).hashCode());
        String $localityCode = this.getLocalityCode();
        result = result * 59 + ($localityCode == null ? 43 : $localityCode.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HouseholdSearch(localityCode=" + this.getLocalityCode() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", searchRadius=" + this.getSearchRadius() + ")";
    }

    public HouseholdSearch() {
    }

    public HouseholdSearch(String localityCode, Double latitude, Double longitude, Double searchRadius) {
        this.localityCode = localityCode;
        this.latitude = latitude;
        this.longitude = longitude;
        this.searchRadius = searchRadius;
    }

    public static abstract class HouseholdSearchBuilder<C extends HouseholdSearch, B extends HouseholdSearchBuilder<C, B>>
    extends EgovOfflineSearchModel.EgovOfflineSearchModelBuilder<C, B> {
        private String localityCode;
        private Double latitude;
        private Double longitude;
        private Double searchRadius;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="boundaryCode")
        public B localityCode(String localityCode) {
            this.localityCode = localityCode;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(Double latitude) {
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(Double longitude) {
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="searchRadius")
        public B searchRadius(Double searchRadius) {
            this.searchRadius = searchRadius;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HouseholdSearch.HouseholdSearchBuilder(super=" + super.toString() + ", localityCode=" + this.localityCode + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", searchRadius=" + this.searchRadius + ")";
        }
    }

    private static final class HouseholdSearchBuilderImpl
    extends HouseholdSearchBuilder<HouseholdSearch, HouseholdSearchBuilderImpl> {
        private HouseholdSearchBuilderImpl() {
        }

        @Override
        protected HouseholdSearchBuilderImpl self() {
            return this;
        }

        @Override
        public HouseholdSearch build() {
            return new HouseholdSearch(this);
        }
    }
}

