/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ApiOperation;
import org.egov.common.models.project.Project;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Projects")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Project> projects = new ArrayList<Project>();
    @JsonProperty(value="apiOperation")
    @Valid
    private ApiOperation apiOperation = null;

    public ProjectRequest addProjectItem(Project projectItem) {
        this.projects.add(projectItem);
        return this;
    }

    public static ProjectRequestBuilder builder() {
        return new ProjectRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public ApiOperation getApiOperation() {
        return this.apiOperation;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Projects")
    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    @JsonProperty(value="apiOperation")
    public void setApiOperation(ApiOperation apiOperation) {
        this.apiOperation = apiOperation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectRequest)) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Project> this$projects = this.getProjects();
        List<Project> other$projects = other.getProjects();
        if (this$projects == null ? other$projects != null : !((Object)this$projects).equals(other$projects)) {
            return false;
        }
        ApiOperation this$apiOperation = this.getApiOperation();
        ApiOperation other$apiOperation = other.getApiOperation();
        return !(this$apiOperation == null ? other$apiOperation != null : !((Object)((Object)this$apiOperation)).equals((Object)other$apiOperation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Project> $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : ((Object)$projects).hashCode());
        ApiOperation $apiOperation = this.getApiOperation();
        result = result * 59 + ($apiOperation == null ? 43 : ((Object)((Object)$apiOperation)).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectRequest(requestInfo=" + this.getRequestInfo() + ", projects=" + this.getProjects() + ", apiOperation=" + this.getApiOperation() + ")";
    }

    public ProjectRequest() {
    }

    public ProjectRequest(RequestInfo requestInfo, List<Project> projects, ApiOperation apiOperation) {
        this.requestInfo = requestInfo;
        this.projects = projects;
        this.apiOperation = apiOperation;
    }

    public static class ProjectRequestBuilder {
        private RequestInfo requestInfo;
        private List<Project> projects;
        private ApiOperation apiOperation;

        ProjectRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Projects")
        public ProjectRequestBuilder projects(List<Project> projects) {
            this.projects = projects;
            return this;
        }

        @JsonProperty(value="apiOperation")
        public ProjectRequestBuilder apiOperation(ApiOperation apiOperation) {
            this.apiOperation = apiOperation;
            return this;
        }

        public ProjectRequest build() {
            return new ProjectRequest(this.requestInfo, this.projects, this.apiOperation);
        }

        public String toString() {
            return "ProjectRequest.ProjectRequestBuilder(requestInfo=" + this.requestInfo + ", projects=" + this.projects + ", apiOperation=" + this.apiOperation + ")";
        }
    }
}

