/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Search model for household member")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMemberSearch {
    @JsonProperty(value="id")
    private List<String> id = null;
    @JsonProperty(value="householdId")
    private String householdId = null;
    @JsonProperty(value="householdClientReferenceId")
    private String householdClientReferenceId = null;
    @JsonProperty(value="individualId")
    private String individualId = null;
    @JsonProperty(value="individualClientReferenceId")
    private String individualClientReferenceId = null;
    @JsonProperty(value="isHeadOfHousehold")
    private Boolean isHeadOfHousehold = null;
    @JsonProperty(value="tenantId")
    @Valid
    private String tenantId = null;

    public static HouseholdMemberSearchBuilder builder() {
        return new HouseholdMemberSearchBuilder();
    }

    public List<String> getId() {
        return this.id;
    }

    public String getHouseholdId() {
        return this.householdId;
    }

    public String getHouseholdClientReferenceId() {
        return this.householdClientReferenceId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getIndividualClientReferenceId() {
        return this.individualClientReferenceId;
    }

    public Boolean getIsHeadOfHousehold() {
        return this.isHeadOfHousehold;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="id")
    public void setId(List<String> id) {
        this.id = id;
    }

    @JsonProperty(value="householdId")
    public void setHouseholdId(String householdId) {
        this.householdId = householdId;
    }

    @JsonProperty(value="householdClientReferenceId")
    public void setHouseholdClientReferenceId(String householdClientReferenceId) {
        this.householdClientReferenceId = householdClientReferenceId;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="individualClientReferenceId")
    public void setIndividualClientReferenceId(String individualClientReferenceId) {
        this.individualClientReferenceId = individualClientReferenceId;
    }

    @JsonProperty(value="isHeadOfHousehold")
    public void setIsHeadOfHousehold(Boolean isHeadOfHousehold) {
        this.isHeadOfHousehold = isHeadOfHousehold;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMemberSearch)) {
            return false;
        }
        HouseholdMemberSearch other = (HouseholdMemberSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isHeadOfHousehold = this.getIsHeadOfHousehold();
        Boolean other$isHeadOfHousehold = other.getIsHeadOfHousehold();
        if (this$isHeadOfHousehold == null ? other$isHeadOfHousehold != null : !((Object)this$isHeadOfHousehold).equals(other$isHeadOfHousehold)) {
            return false;
        }
        List<String> this$id = this.getId();
        List<String> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$householdId = this.getHouseholdId();
        String other$householdId = other.getHouseholdId();
        if (this$householdId == null ? other$householdId != null : !this$householdId.equals(other$householdId)) {
            return false;
        }
        String this$householdClientReferenceId = this.getHouseholdClientReferenceId();
        String other$householdClientReferenceId = other.getHouseholdClientReferenceId();
        if (this$householdClientReferenceId == null ? other$householdClientReferenceId != null : !this$householdClientReferenceId.equals(other$householdClientReferenceId)) {
            return false;
        }
        String this$individualId = this.getIndividualId();
        String other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !this$individualId.equals(other$individualId)) {
            return false;
        }
        String this$individualClientReferenceId = this.getIndividualClientReferenceId();
        String other$individualClientReferenceId = other.getIndividualClientReferenceId();
        if (this$individualClientReferenceId == null ? other$individualClientReferenceId != null : !this$individualClientReferenceId.equals(other$individualClientReferenceId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMemberSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isHeadOfHousehold = this.getIsHeadOfHousehold();
        result = result * 59 + ($isHeadOfHousehold == null ? 43 : ((Object)$isHeadOfHousehold).hashCode());
        List<String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $householdId = this.getHouseholdId();
        result = result * 59 + ($householdId == null ? 43 : $householdId.hashCode());
        String $householdClientReferenceId = this.getHouseholdClientReferenceId();
        result = result * 59 + ($householdClientReferenceId == null ? 43 : $householdClientReferenceId.hashCode());
        String $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : $individualId.hashCode());
        String $individualClientReferenceId = this.getIndividualClientReferenceId();
        result = result * 59 + ($individualClientReferenceId == null ? 43 : $individualClientReferenceId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMemberSearch(id=" + this.getId() + ", householdId=" + this.getHouseholdId() + ", householdClientReferenceId=" + this.getHouseholdClientReferenceId() + ", individualId=" + this.getIndividualId() + ", individualClientReferenceId=" + this.getIndividualClientReferenceId() + ", isHeadOfHousehold=" + this.getIsHeadOfHousehold() + ", tenantId=" + this.getTenantId() + ")";
    }

    public HouseholdMemberSearch() {
    }

    public HouseholdMemberSearch(List<String> id, String householdId, String householdClientReferenceId, String individualId, String individualClientReferenceId, Boolean isHeadOfHousehold, String tenantId) {
        this.id = id;
        this.householdId = householdId;
        this.householdClientReferenceId = householdClientReferenceId;
        this.individualId = individualId;
        this.individualClientReferenceId = individualClientReferenceId;
        this.isHeadOfHousehold = isHeadOfHousehold;
        this.tenantId = tenantId;
    }

    public static class HouseholdMemberSearchBuilder {
        private List<String> id;
        private String householdId;
        private String householdClientReferenceId;
        private String individualId;
        private String individualClientReferenceId;
        private Boolean isHeadOfHousehold;
        private String tenantId;

        HouseholdMemberSearchBuilder() {
        }

        @JsonProperty(value="id")
        public HouseholdMemberSearchBuilder id(List<String> id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="householdId")
        public HouseholdMemberSearchBuilder householdId(String householdId) {
            this.householdId = householdId;
            return this;
        }

        @JsonProperty(value="householdClientReferenceId")
        public HouseholdMemberSearchBuilder householdClientReferenceId(String householdClientReferenceId) {
            this.householdClientReferenceId = householdClientReferenceId;
            return this;
        }

        @JsonProperty(value="individualId")
        public HouseholdMemberSearchBuilder individualId(String individualId) {
            this.individualId = individualId;
            return this;
        }

        @JsonProperty(value="individualClientReferenceId")
        public HouseholdMemberSearchBuilder individualClientReferenceId(String individualClientReferenceId) {
            this.individualClientReferenceId = individualClientReferenceId;
            return this;
        }

        @JsonProperty(value="isHeadOfHousehold")
        public HouseholdMemberSearchBuilder isHeadOfHousehold(Boolean isHeadOfHousehold) {
            this.isHeadOfHousehold = isHeadOfHousehold;
            return this;
        }

        @JsonProperty(value="tenantId")
        public HouseholdMemberSearchBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public HouseholdMemberSearch build() {
            return new HouseholdMemberSearch(this.id, this.householdId, this.householdClientReferenceId, this.individualId, this.individualClientReferenceId, this.isHeadOfHousehold, this.tenantId);
        }

        public String toString() {
            return "HouseholdMemberSearch.HouseholdMemberSearchBuilder(id=" + this.id + ", householdId=" + this.householdId + ", householdClientReferenceId=" + this.householdClientReferenceId + ", individualId=" + this.individualId + ", individualClientReferenceId=" + this.individualClientReferenceId + ", isHeadOfHousehold=" + this.isHeadOfHousehold + ", tenantId=" + this.tenantId + ")";
        }
    }
}

