/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.product.Product;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Product")
    @NotNull
    @Valid
    private List<Product> product = new ArrayList<Product>();

    public ProductResponse addProductItem(Product productItem) {
        this.product.add(productItem);
        return this;
    }

    public static ProductResponseBuilder builder() {
        return new ProductResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Product> getProduct() {
        return this.product;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Product")
    public void setProduct(List<Product> product) {
        this.product = product;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductResponse)) {
            return false;
        }
        ProductResponse other = (ProductResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Product> this$product = this.getProduct();
        List<Product> other$product = other.getProduct();
        return !(this$product == null ? other$product != null : !((Object)this$product).equals(other$product));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Product> $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        return result;
    }

    public String toString() {
        return "ProductResponse(responseInfo=" + this.getResponseInfo() + ", product=" + this.getProduct() + ")";
    }

    public ProductResponse() {
    }

    public ProductResponse(ResponseInfo responseInfo, List<Product> product) {
        this.responseInfo = responseInfo;
        this.product = product;
    }

    public static class ProductResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Product> product;

        ProductResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProductResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Product")
        public ProductResponseBuilder product(List<Product> product) {
            this.product = product;
            return this;
        }

        public ProductResponse build() {
            return new ProductResponse(this.responseInfo, this.product);
        }

        public String toString() {
            return "ProductResponse.ProductResponseBuilder(responseInfo=" + this.responseInfo + ", product=" + this.product + ")";
        }
    }
}

