/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.stock.Stock;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    private List<Stock> stock = new ArrayList<Stock>();

    public StockBulkResponse addStockItem(Stock stockItem) {
        this.stock.add(stockItem);
        return this;
    }

    public static StockBulkResponseBuilder builder() {
        return new StockBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Stock> getStock() {
        return this.stock;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(List<Stock> stock) {
        this.stock = stock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockBulkResponse)) {
            return false;
        }
        StockBulkResponse other = (StockBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Stock> this$stock = this.getStock();
        List<Stock> other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Stock> $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockBulkResponse(responseInfo=" + this.getResponseInfo() + ", stock=" + this.getStock() + ")";
    }

    public StockBulkResponse() {
    }

    public StockBulkResponse(ResponseInfo responseInfo, List<Stock> stock) {
        this.responseInfo = responseInfo;
        this.stock = stock;
    }

    public static class StockBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Stock> stock;

        StockBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public StockBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockBulkResponseBuilder stock(List<Stock> stock) {
            this.stock = stock;
            return this;
        }

        public StockBulkResponse build() {
            return new StockBulkResponse(this.responseInfo, this.stock);
        }

        public String toString() {
            return "StockBulkResponse.StockBulkResponseBuilder(responseInfo=" + this.responseInfo + ", stock=" + this.stock + ")";
        }
    }
}

