/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement.sideeffect;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.referralmanagement.sideeffect.SideEffect;

public class SideEffectBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo;
    @JsonProperty(value="SideEffects")
    @NotNull
    @Valid
    private List<SideEffect> sideEffects = new ArrayList<SideEffect>();

    public SideEffectBulkResponse addSideEffectItem(SideEffect sideEffectItem) {
        if (Objects.isNull(this.sideEffects)) {
            this.sideEffects = new ArrayList<SideEffect>();
        }
        if (Objects.nonNull(sideEffectItem)) {
            this.sideEffects.add(sideEffectItem);
        }
        return this;
    }

    public static SideEffectBulkResponseBuilder builder() {
        return new SideEffectBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<SideEffect> getSideEffects() {
        return this.sideEffects;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="SideEffects")
    public void setSideEffects(List<SideEffect> sideEffects) {
        this.sideEffects = sideEffects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SideEffectBulkResponse)) {
            return false;
        }
        SideEffectBulkResponse other = (SideEffectBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<SideEffect> this$sideEffects = this.getSideEffects();
        List<SideEffect> other$sideEffects = other.getSideEffects();
        return !(this$sideEffects == null ? other$sideEffects != null : !((Object)this$sideEffects).equals(other$sideEffects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SideEffectBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<SideEffect> $sideEffects = this.getSideEffects();
        result = result * 59 + ($sideEffects == null ? 43 : ((Object)$sideEffects).hashCode());
        return result;
    }

    public String toString() {
        return "SideEffectBulkResponse(responseInfo=" + this.getResponseInfo() + ", sideEffects=" + this.getSideEffects() + ")";
    }

    public SideEffectBulkResponse() {
    }

    public SideEffectBulkResponse(ResponseInfo responseInfo, List<SideEffect> sideEffects) {
        this.responseInfo = responseInfo;
        this.sideEffects = sideEffects;
    }

    public static class SideEffectBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<SideEffect> sideEffects;

        SideEffectBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public SideEffectBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="SideEffects")
        public SideEffectBulkResponseBuilder sideEffects(List<SideEffect> sideEffects) {
            this.sideEffects = sideEffects;
            return this;
        }

        public SideEffectBulkResponse build() {
            return new SideEffectBulkResponse(this.responseInfo, this.sideEffects);
        }

        public String toString() {
            return "SideEffectBulkResponse.SideEffectBulkResponseBuilder(responseInfo=" + this.responseInfo + ", sideEffects=" + this.sideEffects + ")";
        }
    }
}

