/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.Role;
import org.egov.common.models.stock.TenantRole;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This is acting ID token of the authenticated user on the server. Any value provided by the clients will be ignored and actual user based on authtoken will be used on the server.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserInfo {
    @JsonProperty(value="tenantId")
    @NotNull
    private String tenantId = null;
    @JsonProperty(value="uuid")
    private String uuid = null;
    @JsonProperty(value="userName")
    @NotNull
    private String userName = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="idToken")
    private String idToken = null;
    @JsonProperty(value="mobile")
    private String mobile = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="primaryrole")
    @NotNull
    @Valid
    private List<Role> primaryrole = new ArrayList<Role>();
    @JsonProperty(value="additionalroles")
    @Valid
    private List<TenantRole> additionalroles = null;

    public UserInfo addPrimaryroleItem(Role primaryroleItem) {
        this.primaryrole.add(primaryroleItem);
        return this;
    }

    public UserInfo addAdditionalrolesItem(TenantRole additionalrolesItem) {
        if (this.additionalroles == null) {
            this.additionalroles = new ArrayList<TenantRole>();
        }
        this.additionalroles.add(additionalrolesItem);
        return this;
    }

    public static UserInfoBuilder builder() {
        return new UserInfoBuilder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public List<Role> getPrimaryrole() {
        return this.primaryrole;
    }

    public List<TenantRole> getAdditionalroles() {
        return this.additionalroles;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="uuid")
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    @JsonProperty(value="mobile")
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="primaryrole")
    public void setPrimaryrole(List<Role> primaryrole) {
        this.primaryrole = primaryrole;
    }

    @JsonProperty(value="additionalroles")
    public void setAdditionalroles(List<TenantRole> additionalroles) {
        this.additionalroles = additionalroles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$idToken = this.getIdToken();
        String other$idToken = other.getIdToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        List<Role> this$primaryrole = this.getPrimaryrole();
        List<Role> other$primaryrole = other.getPrimaryrole();
        if (this$primaryrole == null ? other$primaryrole != null : !((Object)this$primaryrole).equals(other$primaryrole)) {
            return false;
        }
        List<TenantRole> this$additionalroles = this.getAdditionalroles();
        List<TenantRole> other$additionalroles = other.getAdditionalroles();
        return !(this$additionalroles == null ? other$additionalroles != null : !((Object)this$additionalroles).equals(other$additionalroles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $idToken = this.getIdToken();
        result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        List<Role> $primaryrole = this.getPrimaryrole();
        result = result * 59 + ($primaryrole == null ? 43 : ((Object)$primaryrole).hashCode());
        List<TenantRole> $additionalroles = this.getAdditionalroles();
        result = result * 59 + ($additionalroles == null ? 43 : ((Object)$additionalroles).hashCode());
        return result;
    }

    public String toString() {
        return "UserInfo(tenantId=" + this.getTenantId() + ", uuid=" + this.getUuid() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", idToken=" + this.getIdToken() + ", mobile=" + this.getMobile() + ", email=" + this.getEmail() + ", primaryrole=" + this.getPrimaryrole() + ", additionalroles=" + this.getAdditionalroles() + ")";
    }

    public UserInfo() {
    }

    public UserInfo(String tenantId, String uuid, String userName, String password, String idToken, String mobile, String email, List<Role> primaryrole, List<TenantRole> additionalroles) {
        this.tenantId = tenantId;
        this.uuid = uuid;
        this.userName = userName;
        this.password = password;
        this.idToken = idToken;
        this.mobile = mobile;
        this.email = email;
        this.primaryrole = primaryrole;
        this.additionalroles = additionalroles;
    }

    public static class UserInfoBuilder {
        private String tenantId;
        private String uuid;
        private String userName;
        private String password;
        private String idToken;
        private String mobile;
        private String email;
        private List<Role> primaryrole;
        private List<TenantRole> additionalroles;

        UserInfoBuilder() {
        }

        @JsonProperty(value="tenantId")
        public UserInfoBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="uuid")
        public UserInfoBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @JsonProperty(value="userName")
        public UserInfoBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @JsonProperty(value="password")
        public UserInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        @JsonProperty(value="idToken")
        public UserInfoBuilder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @JsonProperty(value="mobile")
        public UserInfoBuilder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        @JsonProperty(value="email")
        public UserInfoBuilder email(String email) {
            this.email = email;
            return this;
        }

        @JsonProperty(value="primaryrole")
        public UserInfoBuilder primaryrole(List<Role> primaryrole) {
            this.primaryrole = primaryrole;
            return this;
        }

        @JsonProperty(value="additionalroles")
        public UserInfoBuilder additionalroles(List<TenantRole> additionalroles) {
            this.additionalroles = additionalroles;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.tenantId, this.uuid, this.userName, this.password, this.idToken, this.mobile, this.email, this.primaryrole, this.additionalroles);
        }

        public String toString() {
            return "UserInfo.UserInfoBuilder(tenantId=" + this.tenantId + ", uuid=" + this.uuid + ", userName=" + this.userName + ", password=" + this.password + ", idToken=" + this.idToken + ", mobile=" + this.mobile + ", email=" + this.email + ", primaryrole=" + this.primaryrole + ", additionalroles=" + this.additionalroles + ")";
        }
    }
}

