/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.facility;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.facility.Facility;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class FacilityBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Facilities")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Facility> facilities = new ArrayList<Facility>();

    public FacilityBulkRequest addFacilityItem(Facility facilityItem) {
        this.facilities.add(facilityItem);
        return this;
    }

    public static FacilityBulkRequestBuilder builder() {
        return new FacilityBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Facility> getFacilities() {
        return this.facilities;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Facilities")
    public void setFacilities(List<Facility> facilities) {
        this.facilities = facilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacilityBulkRequest)) {
            return false;
        }
        FacilityBulkRequest other = (FacilityBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Facility> this$facilities = this.getFacilities();
        List<Facility> other$facilities = other.getFacilities();
        return !(this$facilities == null ? other$facilities != null : !((Object)this$facilities).equals(other$facilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FacilityBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Facility> $facilities = this.getFacilities();
        result = result * 59 + ($facilities == null ? 43 : ((Object)$facilities).hashCode());
        return result;
    }

    public String toString() {
        return "FacilityBulkRequest(requestInfo=" + this.getRequestInfo() + ", facilities=" + this.getFacilities() + ")";
    }

    public FacilityBulkRequest() {
    }

    public FacilityBulkRequest(RequestInfo requestInfo, List<Facility> facilities) {
        this.requestInfo = requestInfo;
        this.facilities = facilities;
    }

    public static class FacilityBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Facility> facilities;

        FacilityBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public FacilityBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Facilities")
        public FacilityBulkRequestBuilder facilities(List<Facility> facilities) {
            this.facilities = facilities;
            return this;
        }

        public FacilityBulkRequest build() {
            return new FacilityBulkRequest(this.requestInfo, this.facilities);
        }

        public String toString() {
            return "FacilityBulkRequest.FacilityBulkRequestBuilder(requestInfo=" + this.requestInfo + ", facilities=" + this.facilities + ")";
        }
    }
}

