/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.household.HouseholdMember;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMemberRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="HouseholdMember")
    @NotNull
    @Valid
    private HouseholdMember householdMember = null;

    public static HouseholdMemberRequestBuilder builder() {
        return new HouseholdMemberRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public HouseholdMember getHouseholdMember() {
        return this.householdMember;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="HouseholdMember")
    public void setHouseholdMember(HouseholdMember householdMember) {
        this.householdMember = householdMember;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMemberRequest)) {
            return false;
        }
        HouseholdMemberRequest other = (HouseholdMemberRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        HouseholdMember this$householdMember = this.getHouseholdMember();
        HouseholdMember other$householdMember = other.getHouseholdMember();
        return !(this$householdMember == null ? other$householdMember != null : !((Object)this$householdMember).equals(other$householdMember));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMemberRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        HouseholdMember $householdMember = this.getHouseholdMember();
        result = result * 59 + ($householdMember == null ? 43 : ((Object)$householdMember).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMemberRequest(requestInfo=" + this.getRequestInfo() + ", householdMember=" + this.getHouseholdMember() + ")";
    }

    public HouseholdMemberRequest() {
    }

    public HouseholdMemberRequest(RequestInfo requestInfo, HouseholdMember householdMember) {
        this.requestInfo = requestInfo;
        this.householdMember = householdMember;
    }

    public static class HouseholdMemberRequestBuilder {
        private RequestInfo requestInfo;
        private HouseholdMember householdMember;

        HouseholdMemberRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HouseholdMemberRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="HouseholdMember")
        public HouseholdMemberRequestBuilder householdMember(HouseholdMember householdMember) {
            this.householdMember = householdMember;
            return this;
        }

        public HouseholdMemberRequest build() {
            return new HouseholdMemberRequest(this.requestInfo, this.householdMember);
        }

        public String toString() {
            return "HouseholdMemberRequest.HouseholdMemberRequestBuilder(requestInfo=" + this.requestInfo + ", householdMember=" + this.householdMember + ")";
        }
    }
}

