/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.Boundary;
import org.egov.common.models.project.AddressType;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Representation of a address. Individual APIs may choose to extend from this using allOf if more details needed to be added in their case. ")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Address {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="doorNo")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String doorNo = null;
    @JsonProperty(value="latitude")
    @DecimalMin(value="-90")
    @DecimalMax(value="90")
    private @DecimalMin(value="-90") @DecimalMax(value="90") Double latitude = null;
    @JsonProperty(value="longitude")
    @DecimalMin(value="-180")
    @DecimalMax(value="180")
    private @DecimalMin(value="-180") @DecimalMax(value="180") Double longitude = null;
    @JsonProperty(value="locationAccuracy")
    @DecimalMin(value="0")
    @DecimalMax(value="10000")
    private @DecimalMin(value="0") @DecimalMax(value="10000") Double locationAccuracy = null;
    @JsonProperty(value="type")
    @NotNull
    private AddressType type = null;
    @JsonProperty(value="addressLine1")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String addressLine1 = null;
    @JsonProperty(value="addressLine2")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String addressLine2 = null;
    @JsonProperty(value="landmark")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String landmark = null;
    @JsonProperty(value="city")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String city = null;
    @JsonProperty(value="pincode")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String pincode = null;
    @JsonProperty(value="buildingName")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String buildingName = null;
    @JsonProperty(value="street")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String street = null;
    @JsonProperty(value="boundaryType")
    private String boundaryType = null;
    @JsonProperty(value="boundary")
    private String boundary = null;
    @JsonProperty(value="locality")
    @Valid
    private Boundary locality = null;

    public static AddressBuilder builder() {
        return new AddressBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLocationAccuracy() {
        return this.locationAccuracy;
    }

    public AddressType getType() {
        return this.type;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public String getLandmark() {
        return this.landmark;
    }

    public String getCity() {
        return this.city;
    }

    public String getPincode() {
        return this.pincode;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getStreet() {
        return this.street;
    }

    public String getBoundaryType() {
        return this.boundaryType;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Boundary getLocality() {
        return this.locality;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="doorNo")
    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="locationAccuracy")
    public void setLocationAccuracy(Double locationAccuracy) {
        this.locationAccuracy = locationAccuracy;
    }

    @JsonProperty(value="type")
    public void setType(AddressType type) {
        this.type = type;
    }

    @JsonProperty(value="addressLine1")
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    @JsonProperty(value="addressLine2")
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    @JsonProperty(value="landmark")
    public void setLandmark(String landmark) {
        this.landmark = landmark;
    }

    @JsonProperty(value="city")
    public void setCity(String city) {
        this.city = city;
    }

    @JsonProperty(value="pincode")
    public void setPincode(String pincode) {
        this.pincode = pincode;
    }

    @JsonProperty(value="buildingName")
    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    @JsonProperty(value="street")
    public void setStreet(String street) {
        this.street = street;
    }

    @JsonProperty(value="boundaryType")
    public void setBoundaryType(String boundaryType) {
        this.boundaryType = boundaryType;
    }

    @JsonProperty(value="boundary")
    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    @JsonProperty(value="locality")
    public void setLocality(Boundary locality) {
        this.locality = locality;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$locationAccuracy = this.getLocationAccuracy();
        Double other$locationAccuracy = other.getLocationAccuracy();
        if (this$locationAccuracy == null ? other$locationAccuracy != null : !((Object)this$locationAccuracy).equals(other$locationAccuracy)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$doorNo = this.getDoorNo();
        String other$doorNo = other.getDoorNo();
        if (this$doorNo == null ? other$doorNo != null : !this$doorNo.equals(other$doorNo)) {
            return false;
        }
        AddressType this$type = this.getType();
        AddressType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$addressLine1 = this.getAddressLine1();
        String other$addressLine1 = other.getAddressLine1();
        if (this$addressLine1 == null ? other$addressLine1 != null : !this$addressLine1.equals(other$addressLine1)) {
            return false;
        }
        String this$addressLine2 = this.getAddressLine2();
        String other$addressLine2 = other.getAddressLine2();
        if (this$addressLine2 == null ? other$addressLine2 != null : !this$addressLine2.equals(other$addressLine2)) {
            return false;
        }
        String this$landmark = this.getLandmark();
        String other$landmark = other.getLandmark();
        if (this$landmark == null ? other$landmark != null : !this$landmark.equals(other$landmark)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$pincode = this.getPincode();
        String other$pincode = other.getPincode();
        if (this$pincode == null ? other$pincode != null : !this$pincode.equals(other$pincode)) {
            return false;
        }
        String this$buildingName = this.getBuildingName();
        String other$buildingName = other.getBuildingName();
        if (this$buildingName == null ? other$buildingName != null : !this$buildingName.equals(other$buildingName)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$boundaryType = this.getBoundaryType();
        String other$boundaryType = other.getBoundaryType();
        if (this$boundaryType == null ? other$boundaryType != null : !this$boundaryType.equals(other$boundaryType)) {
            return false;
        }
        String this$boundary = this.getBoundary();
        String other$boundary = other.getBoundary();
        if (this$boundary == null ? other$boundary != null : !this$boundary.equals(other$boundary)) {
            return false;
        }
        Boundary this$locality = this.getLocality();
        Boundary other$locality = other.getLocality();
        return !(this$locality == null ? other$locality != null : !((Object)this$locality).equals(other$locality));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $locationAccuracy = this.getLocationAccuracy();
        result = result * 59 + ($locationAccuracy == null ? 43 : ((Object)$locationAccuracy).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $doorNo = this.getDoorNo();
        result = result * 59 + ($doorNo == null ? 43 : $doorNo.hashCode());
        AddressType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $addressLine1 = this.getAddressLine1();
        result = result * 59 + ($addressLine1 == null ? 43 : $addressLine1.hashCode());
        String $addressLine2 = this.getAddressLine2();
        result = result * 59 + ($addressLine2 == null ? 43 : $addressLine2.hashCode());
        String $landmark = this.getLandmark();
        result = result * 59 + ($landmark == null ? 43 : $landmark.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $pincode = this.getPincode();
        result = result * 59 + ($pincode == null ? 43 : $pincode.hashCode());
        String $buildingName = this.getBuildingName();
        result = result * 59 + ($buildingName == null ? 43 : $buildingName.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $boundaryType = this.getBoundaryType();
        result = result * 59 + ($boundaryType == null ? 43 : $boundaryType.hashCode());
        String $boundary = this.getBoundary();
        result = result * 59 + ($boundary == null ? 43 : $boundary.hashCode());
        Boundary $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : ((Object)$locality).hashCode());
        return result;
    }

    public String toString() {
        return "Address(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", clientReferenceId=" + this.getClientReferenceId() + ", doorNo=" + this.getDoorNo() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", locationAccuracy=" + this.getLocationAccuracy() + ", type=" + this.getType() + ", addressLine1=" + this.getAddressLine1() + ", addressLine2=" + this.getAddressLine2() + ", landmark=" + this.getLandmark() + ", city=" + this.getCity() + ", pincode=" + this.getPincode() + ", buildingName=" + this.getBuildingName() + ", street=" + this.getStreet() + ", boundaryType=" + this.getBoundaryType() + ", boundary=" + this.getBoundary() + ", locality=" + this.getLocality() + ")";
    }

    public Address() {
    }

    public Address(String id, String tenantId, String clientReferenceId, String doorNo, Double latitude, Double longitude, Double locationAccuracy, AddressType type, String addressLine1, String addressLine2, String landmark, String city, String pincode, String buildingName, String street, String boundaryType, String boundary, Boundary locality) {
        this.id = id;
        this.tenantId = tenantId;
        this.clientReferenceId = clientReferenceId;
        this.doorNo = doorNo;
        this.latitude = latitude;
        this.longitude = longitude;
        this.locationAccuracy = locationAccuracy;
        this.type = type;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.landmark = landmark;
        this.city = city;
        this.pincode = pincode;
        this.buildingName = buildingName;
        this.street = street;
        this.boundaryType = boundaryType;
        this.boundary = boundary;
        this.locality = locality;
    }

    public static class AddressBuilder {
        private String id;
        private String tenantId;
        private String clientReferenceId;
        private String doorNo;
        private Double latitude;
        private Double longitude;
        private Double locationAccuracy;
        private AddressType type;
        private String addressLine1;
        private String addressLine2;
        private String landmark;
        private String city;
        private String pincode;
        private String buildingName;
        private String street;
        private String boundaryType;
        private String boundary;
        private Boundary locality;

        AddressBuilder() {
        }

        @JsonProperty(value="id")
        public AddressBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public AddressBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public AddressBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="doorNo")
        public AddressBuilder doorNo(String doorNo) {
            this.doorNo = doorNo;
            return this;
        }

        @JsonProperty(value="latitude")
        public AddressBuilder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="longitude")
        public AddressBuilder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="locationAccuracy")
        public AddressBuilder locationAccuracy(Double locationAccuracy) {
            this.locationAccuracy = locationAccuracy;
            return this;
        }

        @JsonProperty(value="type")
        public AddressBuilder type(AddressType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="addressLine1")
        public AddressBuilder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        @JsonProperty(value="addressLine2")
        public AddressBuilder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        @JsonProperty(value="landmark")
        public AddressBuilder landmark(String landmark) {
            this.landmark = landmark;
            return this;
        }

        @JsonProperty(value="city")
        public AddressBuilder city(String city) {
            this.city = city;
            return this;
        }

        @JsonProperty(value="pincode")
        public AddressBuilder pincode(String pincode) {
            this.pincode = pincode;
            return this;
        }

        @JsonProperty(value="buildingName")
        public AddressBuilder buildingName(String buildingName) {
            this.buildingName = buildingName;
            return this;
        }

        @JsonProperty(value="street")
        public AddressBuilder street(String street) {
            this.street = street;
            return this;
        }

        @JsonProperty(value="boundaryType")
        public AddressBuilder boundaryType(String boundaryType) {
            this.boundaryType = boundaryType;
            return this;
        }

        @JsonProperty(value="boundary")
        public AddressBuilder boundary(String boundary) {
            this.boundary = boundary;
            return this;
        }

        @JsonProperty(value="locality")
        public AddressBuilder locality(Boundary locality) {
            this.locality = locality;
            return this;
        }

        public Address build() {
            return new Address(this.id, this.tenantId, this.clientReferenceId, this.doorNo, this.latitude, this.longitude, this.locationAccuracy, this.type, this.addressLine1, this.addressLine2, this.landmark, this.city, this.pincode, this.buildingName, this.street, this.boundaryType, this.boundary, this.locality);
        }

        public String toString() {
            return "Address.AddressBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", clientReferenceId=" + this.clientReferenceId + ", doorNo=" + this.doorNo + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", locationAccuracy=" + this.locationAccuracy + ", type=" + this.type + ", addressLine1=" + this.addressLine1 + ", addressLine2=" + this.addressLine2 + ", landmark=" + this.landmark + ", city=" + this.city + ", pincode=" + this.pincode + ", buildingName=" + this.buildingName + ", street=" + this.street + ", boundaryType=" + this.boundaryType + ", boundary=" + this.boundary + ", locality=" + this.locality + ")";
        }
    }
}

