/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.project.AdditionalFields;
import org.egov.common.models.project.Address;
import org.egov.common.models.project.TaskResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Task {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    private String tenantId = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="projectBeneficiaryId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectBeneficiaryId = null;
    @JsonProperty(value="projectBeneficiaryClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectBeneficiaryClientReferenceId = null;
    @JsonProperty(value="resources")
    @Valid
    private List<TaskResource> resources;
    @JsonProperty(value="plannedStartDate")
    private Long plannedStartDate = null;
    @JsonProperty(value="plannedEndDate")
    private Long plannedEndDate = null;
    @JsonProperty(value="actualStartDate")
    private Long actualStartDate = null;
    @JsonProperty(value="actualEndDate")
    private Long actualEndDate = null;
    @JsonProperty(value="createdBy")
    private String createdBy = null;
    @JsonProperty(value="createdDate")
    private Long createdDate = null;
    @JsonProperty(value="address")
    @Valid
    private Address address = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;

    public Task addResourcesItem(TaskResource resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    private static List<TaskResource> $default$resources() {
        return new ArrayList<TaskResource>();
    }

    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectBeneficiaryId() {
        return this.projectBeneficiaryId;
    }

    public String getProjectBeneficiaryClientReferenceId() {
        return this.projectBeneficiaryClientReferenceId;
    }

    public List<TaskResource> getResources() {
        return this.resources;
    }

    public Long getPlannedStartDate() {
        return this.plannedStartDate;
    }

    public Long getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public Long getActualStartDate() {
        return this.actualStartDate;
    }

    public Long getActualEndDate() {
        return this.actualEndDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Address getAddress() {
        return this.address;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="projectBeneficiaryId")
    public void setProjectBeneficiaryId(String projectBeneficiaryId) {
        this.projectBeneficiaryId = projectBeneficiaryId;
    }

    @JsonProperty(value="projectBeneficiaryClientReferenceId")
    public void setProjectBeneficiaryClientReferenceId(String projectBeneficiaryClientReferenceId) {
        this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
    }

    @JsonProperty(value="resources")
    public void setResources(List<TaskResource> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="plannedStartDate")
    public void setPlannedStartDate(Long plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    @JsonProperty(value="plannedEndDate")
    public void setPlannedEndDate(Long plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @JsonProperty(value="actualStartDate")
    public void setActualStartDate(Long actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    @JsonProperty(value="actualEndDate")
    public void setActualEndDate(Long actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="createdDate")
    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$plannedStartDate = this.getPlannedStartDate();
        Long other$plannedStartDate = other.getPlannedStartDate();
        if (this$plannedStartDate == null ? other$plannedStartDate != null : !((Object)this$plannedStartDate).equals(other$plannedStartDate)) {
            return false;
        }
        Long this$plannedEndDate = this.getPlannedEndDate();
        Long other$plannedEndDate = other.getPlannedEndDate();
        if (this$plannedEndDate == null ? other$plannedEndDate != null : !((Object)this$plannedEndDate).equals(other$plannedEndDate)) {
            return false;
        }
        Long this$actualStartDate = this.getActualStartDate();
        Long other$actualStartDate = other.getActualStartDate();
        if (this$actualStartDate == null ? other$actualStartDate != null : !((Object)this$actualStartDate).equals(other$actualStartDate)) {
            return false;
        }
        Long this$actualEndDate = this.getActualEndDate();
        Long other$actualEndDate = other.getActualEndDate();
        if (this$actualEndDate == null ? other$actualEndDate != null : !((Object)this$actualEndDate).equals(other$actualEndDate)) {
            return false;
        }
        Long this$createdDate = this.getCreatedDate();
        Long other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectBeneficiaryId = this.getProjectBeneficiaryId();
        String other$projectBeneficiaryId = other.getProjectBeneficiaryId();
        if (this$projectBeneficiaryId == null ? other$projectBeneficiaryId != null : !this$projectBeneficiaryId.equals(other$projectBeneficiaryId)) {
            return false;
        }
        String this$projectBeneficiaryClientReferenceId = this.getProjectBeneficiaryClientReferenceId();
        String other$projectBeneficiaryClientReferenceId = other.getProjectBeneficiaryClientReferenceId();
        if (this$projectBeneficiaryClientReferenceId == null ? other$projectBeneficiaryClientReferenceId != null : !this$projectBeneficiaryClientReferenceId.equals(other$projectBeneficiaryClientReferenceId)) {
            return false;
        }
        List<TaskResource> this$resources = this.getResources();
        List<TaskResource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        if (this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $plannedStartDate = this.getPlannedStartDate();
        result = result * 59 + ($plannedStartDate == null ? 43 : ((Object)$plannedStartDate).hashCode());
        Long $plannedEndDate = this.getPlannedEndDate();
        result = result * 59 + ($plannedEndDate == null ? 43 : ((Object)$plannedEndDate).hashCode());
        Long $actualStartDate = this.getActualStartDate();
        result = result * 59 + ($actualStartDate == null ? 43 : ((Object)$actualStartDate).hashCode());
        Long $actualEndDate = this.getActualEndDate();
        result = result * 59 + ($actualEndDate == null ? 43 : ((Object)$actualEndDate).hashCode());
        Long $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectBeneficiaryId = this.getProjectBeneficiaryId();
        result = result * 59 + ($projectBeneficiaryId == null ? 43 : $projectBeneficiaryId.hashCode());
        String $projectBeneficiaryClientReferenceId = this.getProjectBeneficiaryClientReferenceId();
        result = result * 59 + ($projectBeneficiaryClientReferenceId == null ? 43 : $projectBeneficiaryClientReferenceId.hashCode());
        List<TaskResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "Task(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", clientReferenceId=" + this.getClientReferenceId() + ", projectId=" + this.getProjectId() + ", projectBeneficiaryId=" + this.getProjectBeneficiaryId() + ", projectBeneficiaryClientReferenceId=" + this.getProjectBeneficiaryClientReferenceId() + ", resources=" + this.getResources() + ", plannedStartDate=" + this.getPlannedStartDate() + ", plannedEndDate=" + this.getPlannedEndDate() + ", actualStartDate=" + this.getActualStartDate() + ", actualEndDate=" + this.getActualEndDate() + ", createdBy=" + this.getCreatedBy() + ", createdDate=" + this.getCreatedDate() + ", address=" + this.getAddress() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", auditDetails=" + this.getAuditDetails() + ", clientAuditDetails=" + this.getClientAuditDetails() + ", status=" + this.getStatus() + ", hasErrors=" + this.getHasErrors() + ")";
    }

    public Task() {
        this.resources = Task.$default$resources();
    }

    public Task(String id, String tenantId, String clientReferenceId, String projectId, String projectBeneficiaryId, String projectBeneficiaryClientReferenceId, List<TaskResource> resources, Long plannedStartDate, Long plannedEndDate, Long actualStartDate, Long actualEndDate, String createdBy, Long createdDate, Address address, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails, AuditDetails clientAuditDetails, String status, Boolean hasErrors) {
        this.id = id;
        this.tenantId = tenantId;
        this.clientReferenceId = clientReferenceId;
        this.projectId = projectId;
        this.projectBeneficiaryId = projectBeneficiaryId;
        this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
        this.resources = resources;
        this.plannedStartDate = plannedStartDate;
        this.plannedEndDate = plannedEndDate;
        this.actualStartDate = actualStartDate;
        this.actualEndDate = actualEndDate;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.address = address;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
        this.clientAuditDetails = clientAuditDetails;
        this.status = status;
        this.hasErrors = hasErrors;
    }

    public static class TaskBuilder {
        private String id;
        private String tenantId;
        private String clientReferenceId;
        private String projectId;
        private String projectBeneficiaryId;
        private String projectBeneficiaryClientReferenceId;
        private boolean resources$set;
        private List<TaskResource> resources$value;
        private Long plannedStartDate;
        private Long plannedEndDate;
        private Long actualStartDate;
        private Long actualEndDate;
        private String createdBy;
        private Long createdDate;
        private Address address;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;
        private AuditDetails clientAuditDetails;
        private String status;
        private Boolean hasErrors;

        TaskBuilder() {
        }

        @JsonProperty(value="id")
        public TaskBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public TaskBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public TaskBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="projectId")
        public TaskBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="projectBeneficiaryId")
        public TaskBuilder projectBeneficiaryId(String projectBeneficiaryId) {
            this.projectBeneficiaryId = projectBeneficiaryId;
            return this;
        }

        @JsonProperty(value="projectBeneficiaryClientReferenceId")
        public TaskBuilder projectBeneficiaryClientReferenceId(String projectBeneficiaryClientReferenceId) {
            this.projectBeneficiaryClientReferenceId = projectBeneficiaryClientReferenceId;
            return this;
        }

        @JsonProperty(value="resources")
        public TaskBuilder resources(List<TaskResource> resources) {
            this.resources$value = resources;
            this.resources$set = true;
            return this;
        }

        @JsonProperty(value="plannedStartDate")
        public TaskBuilder plannedStartDate(Long plannedStartDate) {
            this.plannedStartDate = plannedStartDate;
            return this;
        }

        @JsonProperty(value="plannedEndDate")
        public TaskBuilder plannedEndDate(Long plannedEndDate) {
            this.plannedEndDate = plannedEndDate;
            return this;
        }

        @JsonProperty(value="actualStartDate")
        public TaskBuilder actualStartDate(Long actualStartDate) {
            this.actualStartDate = actualStartDate;
            return this;
        }

        @JsonProperty(value="actualEndDate")
        public TaskBuilder actualEndDate(Long actualEndDate) {
            this.actualEndDate = actualEndDate;
            return this;
        }

        @JsonProperty(value="createdBy")
        public TaskBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @JsonProperty(value="createdDate")
        public TaskBuilder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @JsonProperty(value="address")
        public TaskBuilder address(Address address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public TaskBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public TaskBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public TaskBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public TaskBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public TaskBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        @JsonProperty(value="status")
        public TaskBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonIgnore
        public TaskBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public Task build() {
            List resources$value = this.resources$value;
            if (!this.resources$set) {
                resources$value = Task.$default$resources();
            }
            return new Task(this.id, this.tenantId, this.clientReferenceId, this.projectId, this.projectBeneficiaryId, this.projectBeneficiaryClientReferenceId, resources$value, this.plannedStartDate, this.plannedEndDate, this.actualStartDate, this.actualEndDate, this.createdBy, this.createdDate, this.address, this.additionalFields, this.isDeleted, this.rowVersion, this.auditDetails, this.clientAuditDetails, this.status, this.hasErrors);
        }

        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", clientReferenceId=" + this.clientReferenceId + ", projectId=" + this.projectId + ", projectBeneficiaryId=" + this.projectBeneficiaryId + ", projectBeneficiaryClientReferenceId=" + this.projectBeneficiaryClientReferenceId + ", resources$value=" + this.resources$value + ", plannedStartDate=" + this.plannedStartDate + ", plannedEndDate=" + this.plannedEndDate + ", actualStartDate=" + this.actualStartDate + ", actualEndDate=" + this.actualEndDate + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", address=" + this.address + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ", clientAuditDetails=" + this.clientAuditDetails + ", status=" + this.status + ", hasErrors=" + this.hasErrors + ")";
        }
    }
}

