/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.Project;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Project")
    @NotNull
    @Valid
    private List<Project> project = new ArrayList<Project>();
    @JsonProperty(value="TotalCount")
    private Integer totalCount = 0;

    public ProjectResponse addProjectItem(Project projectItem) {
        this.project.add(projectItem);
        return this;
    }

    public static ProjectResponseBuilder builder() {
        return new ProjectResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Project> getProject() {
        return this.project;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Project")
    public void setProject(List<Project> project) {
        this.project = project;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResponse)) {
            return false;
        }
        ProjectResponse other = (ProjectResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Project> this$project = this.getProject();
        List<Project> other$project = other.getProject();
        return !(this$project == null ? other$project != null : !((Object)this$project).equals(other$project));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Project> $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectResponse(responseInfo=" + this.getResponseInfo() + ", project=" + this.getProject() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public ProjectResponse() {
    }

    public ProjectResponse(ResponseInfo responseInfo, List<Project> project, Integer totalCount) {
        this.responseInfo = responseInfo;
        this.project = project;
        this.totalCount = totalCount;
    }

    public static class ProjectResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Project> project;
        private Integer totalCount;

        ProjectResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProjectResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Project")
        public ProjectResponseBuilder project(List<Project> project) {
            this.project = project;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public ProjectResponseBuilder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public ProjectResponse build() {
            return new ProjectResponse(this.responseInfo, this.project, this.totalCount);
        }

        public String toString() {
            return "ProjectResponse.ProjectResponseBuilder(responseInfo=" + this.responseInfo + ", project=" + this.project + ", totalCount=" + this.totalCount + ")";
        }
    }
}

