/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.product.ProductVariantSearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductVariantSearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProductVariant")
    @NotNull
    @Valid
    private ProductVariantSearch productVariant = null;

    public static ProductVariantSearchRequestBuilder builder() {
        return new ProductVariantSearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public ProductVariantSearch getProductVariant() {
        return this.productVariant;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProductVariant")
    public void setProductVariant(ProductVariantSearch productVariant) {
        this.productVariant = productVariant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVariantSearchRequest)) {
            return false;
        }
        ProductVariantSearchRequest other = (ProductVariantSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        ProductVariantSearch this$productVariant = this.getProductVariant();
        ProductVariantSearch other$productVariant = other.getProductVariant();
        return !(this$productVariant == null ? other$productVariant != null : !((Object)this$productVariant).equals(other$productVariant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductVariantSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        ProductVariantSearch $productVariant = this.getProductVariant();
        result = result * 59 + ($productVariant == null ? 43 : ((Object)$productVariant).hashCode());
        return result;
    }

    public String toString() {
        return "ProductVariantSearchRequest(requestInfo=" + this.getRequestInfo() + ", productVariant=" + this.getProductVariant() + ")";
    }

    public ProductVariantSearchRequest() {
    }

    public ProductVariantSearchRequest(RequestInfo requestInfo, ProductVariantSearch productVariant) {
        this.requestInfo = requestInfo;
        this.productVariant = productVariant;
    }

    public static class ProductVariantSearchRequestBuilder {
        private RequestInfo requestInfo;
        private ProductVariantSearch productVariant;

        ProductVariantSearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProductVariantSearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProductVariant")
        public ProductVariantSearchRequestBuilder productVariant(ProductVariantSearch productVariant) {
            this.productVariant = productVariant;
            return this;
        }

        public ProductVariantSearchRequest build() {
            return new ProductVariantSearchRequest(this.requestInfo, this.productVariant);
        }

        public String toString() {
            return "ProductVariantSearchRequest.ProductVariantSearchRequestBuilder(requestInfo=" + this.requestInfo + ", productVariant=" + this.productVariant + ")";
        }
    }
}

