/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.product.ApiOperation;
import org.egov.common.models.product.ProductVariant;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductVariantRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProductVariant")
    @NotNull
    @Size(min=1)
    @Valid
    private @NotNull @Size(min=1) @Valid List<ProductVariant> productVariant = new ArrayList<ProductVariant>();
    @JsonProperty(value="apiOperation")
    @Valid
    private ApiOperation apiOperation = null;

    public ProductVariantRequest addProductVariantItem(ProductVariant productVariantItem) {
        this.productVariant.add(productVariantItem);
        return this;
    }

    public static ProductVariantRequestBuilder builder() {
        return new ProductVariantRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProductVariant> getProductVariant() {
        return this.productVariant;
    }

    public ApiOperation getApiOperation() {
        return this.apiOperation;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProductVariant")
    public void setProductVariant(List<ProductVariant> productVariant) {
        this.productVariant = productVariant;
    }

    @JsonProperty(value="apiOperation")
    public void setApiOperation(ApiOperation apiOperation) {
        this.apiOperation = apiOperation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVariantRequest)) {
            return false;
        }
        ProductVariantRequest other = (ProductVariantRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<ProductVariant> this$productVariant = this.getProductVariant();
        List<ProductVariant> other$productVariant = other.getProductVariant();
        if (this$productVariant == null ? other$productVariant != null : !((Object)this$productVariant).equals(other$productVariant)) {
            return false;
        }
        ApiOperation this$apiOperation = this.getApiOperation();
        ApiOperation other$apiOperation = other.getApiOperation();
        return !(this$apiOperation == null ? other$apiOperation != null : !((Object)((Object)this$apiOperation)).equals((Object)other$apiOperation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductVariantRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<ProductVariant> $productVariant = this.getProductVariant();
        result = result * 59 + ($productVariant == null ? 43 : ((Object)$productVariant).hashCode());
        ApiOperation $apiOperation = this.getApiOperation();
        result = result * 59 + ($apiOperation == null ? 43 : ((Object)((Object)$apiOperation)).hashCode());
        return result;
    }

    public String toString() {
        return "ProductVariantRequest(requestInfo=" + this.getRequestInfo() + ", productVariant=" + this.getProductVariant() + ", apiOperation=" + (Object)((Object)this.getApiOperation()) + ")";
    }

    public ProductVariantRequest() {
    }

    public ProductVariantRequest(RequestInfo requestInfo, List<ProductVariant> productVariant, ApiOperation apiOperation) {
        this.requestInfo = requestInfo;
        this.productVariant = productVariant;
        this.apiOperation = apiOperation;
    }

    public static class ProductVariantRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProductVariant> productVariant;
        private ApiOperation apiOperation;

        ProductVariantRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProductVariantRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProductVariant")
        public ProductVariantRequestBuilder productVariant(List<ProductVariant> productVariant) {
            this.productVariant = productVariant;
            return this;
        }

        @JsonProperty(value="apiOperation")
        public ProductVariantRequestBuilder apiOperation(ApiOperation apiOperation) {
            this.apiOperation = apiOperation;
            return this;
        }

        public ProductVariantRequest build() {
            return new ProductVariantRequest(this.requestInfo, this.productVariant, this.apiOperation);
        }

        public String toString() {
            return "ProductVariantRequest.ProductVariantRequestBuilder(requestInfo=" + this.requestInfo + ", productVariant=" + this.productVariant + ", apiOperation=" + (Object)((Object)this.apiOperation) + ")";
        }
    }
}

