/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.Role;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="User role carries the tenant related role information for the user. A user can have multiple roles per tenant based on the need of the tenant. A user may also have multiple roles for multiple tenants.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TenantRole {
    @JsonProperty(value="tenantId")
    @NotNull
    private String tenantId = null;
    @JsonProperty(value="roles")
    @NotNull
    @Valid
    private List<Role> roles = new ArrayList<Role>();

    public TenantRole addRolesItem(Role rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    public static TenantRoleBuilder builder() {
        return new TenantRoleBuilder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantRole)) {
            return false;
        }
        TenantRole other = (TenantRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        List<Role> this$roles = this.getRoles();
        List<Role> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        List<Role> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "TenantRole(tenantId=" + this.getTenantId() + ", roles=" + this.getRoles() + ")";
    }

    public TenantRole() {
    }

    public TenantRole(String tenantId, List<Role> roles) {
        this.tenantId = tenantId;
        this.roles = roles;
    }

    public static class TenantRoleBuilder {
        private String tenantId;
        private List<Role> roles;

        TenantRoleBuilder() {
        }

        @JsonProperty(value="tenantId")
        public TenantRoleBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="roles")
        public TenantRoleBuilder roles(List<Role> roles) {
            this.roles = roles;
            return this;
        }

        public TenantRole build() {
            return new TenantRole(this.tenantId, this.roles);
        }

        public String toString() {
            return "TenantRole.TenantRoleBuilder(tenantId=" + this.tenantId + ", roles=" + this.roles + ")";
        }
    }
}

