/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.stock.AdditionalFields;
import org.egov.common.models.stock.TransactionReason;
import org.egov.common.models.stock.TransactionType;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Stock {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String tenantId;
    @JsonProperty(value="productVariantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String productVariantId;
    @JsonProperty(value="quantity")
    @NotNull
    private Integer quantity;
    @JsonProperty(value="referenceId")
    private String referenceId;
    @JsonProperty(value="referenceIdType")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceIdType;
    @JsonProperty(value="transactionType")
    @NotNull
    @Valid
    private TransactionType transactionType;
    @JsonProperty(value="transactionReason")
    @Valid
    private TransactionReason transactionReason;
    @JsonProperty(value="senderId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String senderId;
    @JsonProperty(value="senderType")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String senderType;
    @JsonProperty(value="receiverId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String receiverId;
    @JsonProperty(value="receiverType")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String receiverType;
    @JsonProperty(value="wayBillNumber")
    @Size(min=2, max=200)
    private @Size(min=2, max=200) String wayBillNumber;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion;
    @JsonIgnore
    private Boolean hasErrors;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails;
    @JsonProperty(value="dateOfEntry")
    private Long dateOfEntry;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails;

    private static Boolean $default$isDeleted() {
        return Boolean.FALSE;
    }

    private static Boolean $default$hasErrors() {
        return Boolean.FALSE;
    }

    public static StockBuilder builder() {
        return new StockBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getProductVariantId() {
        return this.productVariantId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceIdType() {
        return this.referenceIdType;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public TransactionReason getTransactionReason() {
        return this.transactionReason;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getSenderType() {
        return this.senderType;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public String getWayBillNumber() {
        return this.wayBillNumber;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Long getDateOfEntry() {
        return this.dateOfEntry;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="productVariantId")
    public void setProductVariantId(String productVariantId) {
        this.productVariantId = productVariantId;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="referenceIdType")
    public void setReferenceIdType(String referenceIdType) {
        this.referenceIdType = referenceIdType;
    }

    @JsonProperty(value="transactionType")
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @JsonProperty(value="transactionReason")
    public void setTransactionReason(TransactionReason transactionReason) {
        this.transactionReason = transactionReason;
    }

    @JsonProperty(value="senderId")
    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    @JsonProperty(value="senderType")
    public void setSenderType(String senderType) {
        this.senderType = senderType;
    }

    @JsonProperty(value="receiverId")
    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    @JsonProperty(value="receiverType")
    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    @JsonProperty(value="wayBillNumber")
    public void setWayBillNumber(String wayBillNumber) {
        this.wayBillNumber = wayBillNumber;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="dateOfEntry")
    public void setDateOfEntry(Long dateOfEntry) {
        this.dateOfEntry = dateOfEntry;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stock)) {
            return false;
        }
        Stock other = (Stock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        Long this$dateOfEntry = this.getDateOfEntry();
        Long other$dateOfEntry = other.getDateOfEntry();
        if (this$dateOfEntry == null ? other$dateOfEntry != null : !((Object)this$dateOfEntry).equals(other$dateOfEntry)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$productVariantId = this.getProductVariantId();
        String other$productVariantId = other.getProductVariantId();
        if (this$productVariantId == null ? other$productVariantId != null : !this$productVariantId.equals(other$productVariantId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$referenceIdType = this.getReferenceIdType();
        String other$referenceIdType = other.getReferenceIdType();
        if (this$referenceIdType == null ? other$referenceIdType != null : !this$referenceIdType.equals(other$referenceIdType)) {
            return false;
        }
        TransactionType this$transactionType = this.getTransactionType();
        TransactionType other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        TransactionReason this$transactionReason = this.getTransactionReason();
        TransactionReason other$transactionReason = other.getTransactionReason();
        if (this$transactionReason == null ? other$transactionReason != null : !((Object)((Object)this$transactionReason)).equals((Object)other$transactionReason)) {
            return false;
        }
        String this$senderId = this.getSenderId();
        String other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !this$senderId.equals(other$senderId)) {
            return false;
        }
        String this$senderType = this.getSenderType();
        String other$senderType = other.getSenderType();
        if (this$senderType == null ? other$senderType != null : !this$senderType.equals(other$senderType)) {
            return false;
        }
        String this$receiverId = this.getReceiverId();
        String other$receiverId = other.getReceiverId();
        if (this$receiverId == null ? other$receiverId != null : !this$receiverId.equals(other$receiverId)) {
            return false;
        }
        String this$receiverType = this.getReceiverType();
        String other$receiverType = other.getReceiverType();
        if (this$receiverType == null ? other$receiverType != null : !this$receiverType.equals(other$receiverType)) {
            return false;
        }
        String this$wayBillNumber = this.getWayBillNumber();
        String other$wayBillNumber = other.getWayBillNumber();
        if (this$wayBillNumber == null ? other$wayBillNumber != null : !this$wayBillNumber.equals(other$wayBillNumber)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        return !(this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Stock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        Long $dateOfEntry = this.getDateOfEntry();
        result = result * 59 + ($dateOfEntry == null ? 43 : ((Object)$dateOfEntry).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $productVariantId = this.getProductVariantId();
        result = result * 59 + ($productVariantId == null ? 43 : $productVariantId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $referenceIdType = this.getReferenceIdType();
        result = result * 59 + ($referenceIdType == null ? 43 : $referenceIdType.hashCode());
        TransactionType $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        TransactionReason $transactionReason = this.getTransactionReason();
        result = result * 59 + ($transactionReason == null ? 43 : ((Object)((Object)$transactionReason)).hashCode());
        String $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : $senderId.hashCode());
        String $senderType = this.getSenderType();
        result = result * 59 + ($senderType == null ? 43 : $senderType.hashCode());
        String $receiverId = this.getReceiverId();
        result = result * 59 + ($receiverId == null ? 43 : $receiverId.hashCode());
        String $receiverType = this.getReceiverType();
        result = result * 59 + ($receiverType == null ? 43 : $receiverType.hashCode());
        String $wayBillNumber = this.getWayBillNumber();
        result = result * 59 + ($wayBillNumber == null ? 43 : $wayBillNumber.hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Stock(id=" + this.getId() + ", clientReferenceId=" + this.getClientReferenceId() + ", tenantId=" + this.getTenantId() + ", productVariantId=" + this.getProductVariantId() + ", quantity=" + this.getQuantity() + ", referenceId=" + this.getReferenceId() + ", referenceIdType=" + this.getReferenceIdType() + ", transactionType=" + (Object)((Object)this.getTransactionType()) + ", transactionReason=" + (Object)((Object)this.getTransactionReason()) + ", senderId=" + this.getSenderId() + ", senderType=" + this.getSenderType() + ", receiverId=" + this.getReceiverId() + ", receiverType=" + this.getReceiverType() + ", wayBillNumber=" + this.getWayBillNumber() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", hasErrors=" + this.getHasErrors() + ", auditDetails=" + this.getAuditDetails() + ", dateOfEntry=" + this.getDateOfEntry() + ", clientAuditDetails=" + this.getClientAuditDetails() + ")";
    }

    public Stock() {
        this.isDeleted = Stock.$default$isDeleted();
        this.hasErrors = Stock.$default$hasErrors();
    }

    public Stock(String id, String clientReferenceId, String tenantId, String productVariantId, Integer quantity, String referenceId, String referenceIdType, TransactionType transactionType, TransactionReason transactionReason, String senderId, String senderType, String receiverId, String receiverType, String wayBillNumber, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, Boolean hasErrors, AuditDetails auditDetails, Long dateOfEntry, AuditDetails clientAuditDetails) {
        this.id = id;
        this.clientReferenceId = clientReferenceId;
        this.tenantId = tenantId;
        this.productVariantId = productVariantId;
        this.quantity = quantity;
        this.referenceId = referenceId;
        this.referenceIdType = referenceIdType;
        this.transactionType = transactionType;
        this.transactionReason = transactionReason;
        this.senderId = senderId;
        this.senderType = senderType;
        this.receiverId = receiverId;
        this.receiverType = receiverType;
        this.wayBillNumber = wayBillNumber;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.hasErrors = hasErrors;
        this.auditDetails = auditDetails;
        this.dateOfEntry = dateOfEntry;
        this.clientAuditDetails = clientAuditDetails;
    }

    public static class StockBuilder {
        private String id;
        private String clientReferenceId;
        private String tenantId;
        private String productVariantId;
        private Integer quantity;
        private String referenceId;
        private String referenceIdType;
        private TransactionType transactionType;
        private TransactionReason transactionReason;
        private String senderId;
        private String senderType;
        private String receiverId;
        private String receiverType;
        private String wayBillNumber;
        private AdditionalFields additionalFields;
        private boolean isDeleted$set;
        private Boolean isDeleted$value;
        private Integer rowVersion;
        private boolean hasErrors$set;
        private Boolean hasErrors$value;
        private AuditDetails auditDetails;
        private Long dateOfEntry;
        private AuditDetails clientAuditDetails;

        StockBuilder() {
        }

        @JsonProperty(value="id")
        public StockBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public StockBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="tenantId")
        public StockBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="productVariantId")
        public StockBuilder productVariantId(String productVariantId) {
            this.productVariantId = productVariantId;
            return this;
        }

        @JsonProperty(value="quantity")
        public StockBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @JsonProperty(value="referenceId")
        public StockBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="referenceIdType")
        public StockBuilder referenceIdType(String referenceIdType) {
            this.referenceIdType = referenceIdType;
            return this;
        }

        @JsonProperty(value="transactionType")
        public StockBuilder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        @JsonProperty(value="transactionReason")
        public StockBuilder transactionReason(TransactionReason transactionReason) {
            this.transactionReason = transactionReason;
            return this;
        }

        @JsonProperty(value="senderId")
        public StockBuilder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        @JsonProperty(value="senderType")
        public StockBuilder senderType(String senderType) {
            this.senderType = senderType;
            return this;
        }

        @JsonProperty(value="receiverId")
        public StockBuilder receiverId(String receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        @JsonProperty(value="receiverType")
        public StockBuilder receiverType(String receiverType) {
            this.receiverType = receiverType;
            return this;
        }

        @JsonProperty(value="wayBillNumber")
        public StockBuilder wayBillNumber(String wayBillNumber) {
            this.wayBillNumber = wayBillNumber;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public StockBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public StockBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted$value = isDeleted;
            this.isDeleted$set = true;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public StockBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonIgnore
        public StockBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors$value = hasErrors;
            this.hasErrors$set = true;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public StockBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="dateOfEntry")
        public StockBuilder dateOfEntry(Long dateOfEntry) {
            this.dateOfEntry = dateOfEntry;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public StockBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        public Stock build() {
            Boolean isDeleted$value = this.isDeleted$value;
            if (!this.isDeleted$set) {
                isDeleted$value = Stock.$default$isDeleted();
            }
            Boolean hasErrors$value = this.hasErrors$value;
            if (!this.hasErrors$set) {
                hasErrors$value = Stock.$default$hasErrors();
            }
            return new Stock(this.id, this.clientReferenceId, this.tenantId, this.productVariantId, this.quantity, this.referenceId, this.referenceIdType, this.transactionType, this.transactionReason, this.senderId, this.senderType, this.receiverId, this.receiverType, this.wayBillNumber, this.additionalFields, isDeleted$value, this.rowVersion, hasErrors$value, this.auditDetails, this.dateOfEntry, this.clientAuditDetails);
        }

        public String toString() {
            return "Stock.StockBuilder(id=" + this.id + ", clientReferenceId=" + this.clientReferenceId + ", tenantId=" + this.tenantId + ", productVariantId=" + this.productVariantId + ", quantity=" + this.quantity + ", referenceId=" + this.referenceId + ", referenceIdType=" + this.referenceIdType + ", transactionType=" + (Object)((Object)this.transactionType) + ", transactionReason=" + (Object)((Object)this.transactionReason) + ", senderId=" + this.senderId + ", senderType=" + this.senderType + ", receiverId=" + this.receiverId + ", receiverType=" + this.receiverType + ", wayBillNumber=" + this.wayBillNumber + ", additionalFields=" + this.additionalFields + ", isDeleted$value=" + this.isDeleted$value + ", rowVersion=" + this.rowVersion + ", hasErrors$value=" + this.hasErrors$value + ", auditDetails=" + this.auditDetails + ", dateOfEntry=" + this.dateOfEntry + ", clientAuditDetails=" + this.clientAuditDetails + ")";
        }
    }
}

