/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.ProjectResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResourceBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="ProjectResources")
    @NotNull
    @Valid
    private List<ProjectResource> projectResource = new ArrayList<ProjectResource>();

    public ProjectResourceBulkResponse addProjectResourceItem(ProjectResource projectResourceItem) {
        this.projectResource.add(projectResourceItem);
        return this;
    }

    public static ProjectResourceBulkResponseBuilder builder() {
        return new ProjectResourceBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<ProjectResource> getProjectResource() {
        return this.projectResource;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="ProjectResources")
    public void setProjectResource(List<ProjectResource> projectResource) {
        this.projectResource = projectResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResourceBulkResponse)) {
            return false;
        }
        ProjectResourceBulkResponse other = (ProjectResourceBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<ProjectResource> this$projectResource = this.getProjectResource();
        List<ProjectResource> other$projectResource = other.getProjectResource();
        return !(this$projectResource == null ? other$projectResource != null : !((Object)this$projectResource).equals(other$projectResource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectResourceBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<ProjectResource> $projectResource = this.getProjectResource();
        result = result * 59 + ($projectResource == null ? 43 : ((Object)$projectResource).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectResourceBulkResponse(responseInfo=" + this.getResponseInfo() + ", projectResource=" + this.getProjectResource() + ")";
    }

    public ProjectResourceBulkResponse() {
    }

    public ProjectResourceBulkResponse(ResponseInfo responseInfo, List<ProjectResource> projectResource) {
        this.responseInfo = responseInfo;
        this.projectResource = projectResource;
    }

    public static class ProjectResourceBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<ProjectResource> projectResource;

        ProjectResourceBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProjectResourceBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="ProjectResources")
        public ProjectResourceBulkResponseBuilder projectResource(List<ProjectResource> projectResource) {
            this.projectResource = projectResource;
            return this;
        }

        public ProjectResourceBulkResponse build() {
            return new ProjectResourceBulkResponse(this.responseInfo, this.projectResource);
        }

        public String toString() {
            return "ProjectResourceBulkResponse.ProjectResourceBulkResponseBuilder(responseInfo=" + this.responseInfo + ", projectResource=" + this.projectResource + ")";
        }
    }
}

