/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.egov.common.models.individual.Gender;
import org.egov.common.models.individual.Identifier;
import org.egov.common.models.individual.Name;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndividualSearch {
    @JsonProperty(value="id")
    private List<String> id = null;
    @JsonProperty(value="individualId")
    private List<String> individualId = null;
    @JsonProperty(value="clientReferenceId")
    private List<String> clientReferenceId = null;
    @JsonProperty(value="name")
    @Valid
    private Name name = null;
    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    private Date dateOfBirth = null;
    @JsonProperty(value="gender")
    @Valid
    private Gender gender = null;
    @JsonProperty(value="mobileNumber")
    private List<String> mobileNumber = null;
    @JsonProperty(value="socialCategory")
    private String socialCategory = null;
    @JsonProperty(value="wardCode")
    private String wardCode = null;
    @JsonProperty(value="individualName")
    private String individualName = null;
    @JsonProperty(value="createdFrom")
    private BigDecimal createdFrom = null;
    @JsonProperty(value="createdTo")
    private BigDecimal createdTo = null;
    @JsonProperty(value="identifier")
    @Valid
    private Identifier identifier = null;
    @JsonProperty(value="boundaryCode")
    private String boundaryCode = null;
    @JsonProperty(value="roleCodes")
    private List<String> roleCodes = null;
    @JsonProperty(value="username")
    private List<String> username;
    @JsonProperty(value="userId")
    private List<Long> userId;
    @JsonProperty(value="userUuid")
    @Size(min=1)
    private @Size(min=1) List<String> userUuid;
    @JsonProperty(value="type")
    private String type;

    public static IndividualSearchBuilder builder() {
        return new IndividualSearchBuilder();
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getIndividualId() {
        return this.individualId;
    }

    public List<String> getClientReferenceId() {
        return this.clientReferenceId;
    }

    public Name getName() {
        return this.name;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public List<String> getMobileNumber() {
        return this.mobileNumber;
    }

    public String getSocialCategory() {
        return this.socialCategory;
    }

    public String getWardCode() {
        return this.wardCode;
    }

    public String getIndividualName() {
        return this.individualName;
    }

    public BigDecimal getCreatedFrom() {
        return this.createdFrom;
    }

    public BigDecimal getCreatedTo() {
        return this.createdTo;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getBoundaryCode() {
        return this.boundaryCode;
    }

    public List<String> getRoleCodes() {
        return this.roleCodes;
    }

    public List<String> getUsername() {
        return this.username;
    }

    public List<Long> getUserId() {
        return this.userId;
    }

    public List<String> getUserUuid() {
        return this.userUuid;
    }

    public String getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public void setId(List<String> id) {
        this.id = id;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(List<String> individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(List<String> clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="gender")
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JsonProperty(value="mobileNumber")
    public void setMobileNumber(List<String> mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @JsonProperty(value="socialCategory")
    public void setSocialCategory(String socialCategory) {
        this.socialCategory = socialCategory;
    }

    @JsonProperty(value="wardCode")
    public void setWardCode(String wardCode) {
        this.wardCode = wardCode;
    }

    @JsonProperty(value="individualName")
    public void setIndividualName(String individualName) {
        this.individualName = individualName;
    }

    @JsonProperty(value="createdFrom")
    public void setCreatedFrom(BigDecimal createdFrom) {
        this.createdFrom = createdFrom;
    }

    @JsonProperty(value="createdTo")
    public void setCreatedTo(BigDecimal createdTo) {
        this.createdTo = createdTo;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="boundaryCode")
    public void setBoundaryCode(String boundaryCode) {
        this.boundaryCode = boundaryCode;
    }

    @JsonProperty(value="roleCodes")
    public void setRoleCodes(List<String> roleCodes) {
        this.roleCodes = roleCodes;
    }

    @JsonProperty(value="username")
    public void setUsername(List<String> username) {
        this.username = username;
    }

    @JsonProperty(value="userId")
    public void setUserId(List<Long> userId) {
        this.userId = userId;
    }

    @JsonProperty(value="userUuid")
    public void setUserUuid(List<String> userUuid) {
        this.userUuid = userUuid;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndividualSearch)) {
            return false;
        }
        IndividualSearch other = (IndividualSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$id = this.getId();
        List<String> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<String> this$individualId = this.getIndividualId();
        List<String> other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !((Object)this$individualId).equals(other$individualId)) {
            return false;
        }
        List<String> this$clientReferenceId = this.getClientReferenceId();
        List<String> other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !((Object)this$clientReferenceId).equals(other$clientReferenceId)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Date this$dateOfBirth = this.getDateOfBirth();
        Date other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        List<String> this$mobileNumber = this.getMobileNumber();
        List<String> other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !((Object)this$mobileNumber).equals(other$mobileNumber)) {
            return false;
        }
        String this$socialCategory = this.getSocialCategory();
        String other$socialCategory = other.getSocialCategory();
        if (this$socialCategory == null ? other$socialCategory != null : !this$socialCategory.equals(other$socialCategory)) {
            return false;
        }
        String this$wardCode = this.getWardCode();
        String other$wardCode = other.getWardCode();
        if (this$wardCode == null ? other$wardCode != null : !this$wardCode.equals(other$wardCode)) {
            return false;
        }
        String this$individualName = this.getIndividualName();
        String other$individualName = other.getIndividualName();
        if (this$individualName == null ? other$individualName != null : !this$individualName.equals(other$individualName)) {
            return false;
        }
        BigDecimal this$createdFrom = this.getCreatedFrom();
        BigDecimal other$createdFrom = other.getCreatedFrom();
        if (this$createdFrom == null ? other$createdFrom != null : !((Object)this$createdFrom).equals(other$createdFrom)) {
            return false;
        }
        BigDecimal this$createdTo = this.getCreatedTo();
        BigDecimal other$createdTo = other.getCreatedTo();
        if (this$createdTo == null ? other$createdTo != null : !((Object)this$createdTo).equals(other$createdTo)) {
            return false;
        }
        Identifier this$identifier = this.getIdentifier();
        Identifier other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        String this$boundaryCode = this.getBoundaryCode();
        String other$boundaryCode = other.getBoundaryCode();
        if (this$boundaryCode == null ? other$boundaryCode != null : !this$boundaryCode.equals(other$boundaryCode)) {
            return false;
        }
        List<String> this$roleCodes = this.getRoleCodes();
        List<String> other$roleCodes = other.getRoleCodes();
        if (this$roleCodes == null ? other$roleCodes != null : !((Object)this$roleCodes).equals(other$roleCodes)) {
            return false;
        }
        List<String> this$username = this.getUsername();
        List<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        List<Long> this$userId = this.getUserId();
        List<Long> other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<String> this$userUuid = this.getUserUuid();
        List<String> other$userUuid = other.getUserUuid();
        if (this$userUuid == null ? other$userUuid != null : !((Object)this$userUuid).equals(other$userUuid)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndividualSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<String> $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : ((Object)$individualId).hashCode());
        List<String> $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : ((Object)$clientReferenceId).hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Date $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        List<String> $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : ((Object)$mobileNumber).hashCode());
        String $socialCategory = this.getSocialCategory();
        result = result * 59 + ($socialCategory == null ? 43 : $socialCategory.hashCode());
        String $wardCode = this.getWardCode();
        result = result * 59 + ($wardCode == null ? 43 : $wardCode.hashCode());
        String $individualName = this.getIndividualName();
        result = result * 59 + ($individualName == null ? 43 : $individualName.hashCode());
        BigDecimal $createdFrom = this.getCreatedFrom();
        result = result * 59 + ($createdFrom == null ? 43 : ((Object)$createdFrom).hashCode());
        BigDecimal $createdTo = this.getCreatedTo();
        result = result * 59 + ($createdTo == null ? 43 : ((Object)$createdTo).hashCode());
        Identifier $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        String $boundaryCode = this.getBoundaryCode();
        result = result * 59 + ($boundaryCode == null ? 43 : $boundaryCode.hashCode());
        List<String> $roleCodes = this.getRoleCodes();
        result = result * 59 + ($roleCodes == null ? 43 : ((Object)$roleCodes).hashCode());
        List<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        List<Long> $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<String> $userUuid = this.getUserUuid();
        result = result * 59 + ($userUuid == null ? 43 : ((Object)$userUuid).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "IndividualSearch(id=" + this.getId() + ", individualId=" + this.getIndividualId() + ", clientReferenceId=" + this.getClientReferenceId() + ", name=" + this.getName() + ", dateOfBirth=" + this.getDateOfBirth() + ", gender=" + (Object)((Object)this.getGender()) + ", mobileNumber=" + this.getMobileNumber() + ", socialCategory=" + this.getSocialCategory() + ", wardCode=" + this.getWardCode() + ", individualName=" + this.getIndividualName() + ", createdFrom=" + this.getCreatedFrom() + ", createdTo=" + this.getCreatedTo() + ", identifier=" + this.getIdentifier() + ", boundaryCode=" + this.getBoundaryCode() + ", roleCodes=" + this.getRoleCodes() + ", username=" + this.getUsername() + ", userId=" + this.getUserId() + ", userUuid=" + this.getUserUuid() + ", type=" + this.getType() + ")";
    }

    public IndividualSearch() {
    }

    public IndividualSearch(List<String> id, List<String> individualId, List<String> clientReferenceId, Name name, Date dateOfBirth, Gender gender, List<String> mobileNumber, String socialCategory, String wardCode, String individualName, BigDecimal createdFrom, BigDecimal createdTo, Identifier identifier, String boundaryCode, List<String> roleCodes, List<String> username, List<Long> userId, List<String> userUuid, String type) {
        this.id = id;
        this.individualId = individualId;
        this.clientReferenceId = clientReferenceId;
        this.name = name;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.mobileNumber = mobileNumber;
        this.socialCategory = socialCategory;
        this.wardCode = wardCode;
        this.individualName = individualName;
        this.createdFrom = createdFrom;
        this.createdTo = createdTo;
        this.identifier = identifier;
        this.boundaryCode = boundaryCode;
        this.roleCodes = roleCodes;
        this.username = username;
        this.userId = userId;
        this.userUuid = userUuid;
        this.type = type;
    }

    public static class IndividualSearchBuilder {
        private List<String> id;
        private List<String> individualId;
        private List<String> clientReferenceId;
        private Name name;
        private Date dateOfBirth;
        private Gender gender;
        private List<String> mobileNumber;
        private String socialCategory;
        private String wardCode;
        private String individualName;
        private BigDecimal createdFrom;
        private BigDecimal createdTo;
        private Identifier identifier;
        private String boundaryCode;
        private List<String> roleCodes;
        private List<String> username;
        private List<Long> userId;
        private List<String> userUuid;
        private String type;

        IndividualSearchBuilder() {
        }

        @JsonProperty(value="id")
        public IndividualSearchBuilder id(List<String> id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="individualId")
        public IndividualSearchBuilder individualId(List<String> individualId) {
            this.individualId = individualId;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public IndividualSearchBuilder clientReferenceId(List<String> clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="name")
        public IndividualSearchBuilder name(Name name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="dateOfBirth")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
        public IndividualSearchBuilder dateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        @JsonProperty(value="gender")
        public IndividualSearchBuilder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        @JsonProperty(value="mobileNumber")
        public IndividualSearchBuilder mobileNumber(List<String> mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        @JsonProperty(value="socialCategory")
        public IndividualSearchBuilder socialCategory(String socialCategory) {
            this.socialCategory = socialCategory;
            return this;
        }

        @JsonProperty(value="wardCode")
        public IndividualSearchBuilder wardCode(String wardCode) {
            this.wardCode = wardCode;
            return this;
        }

        @JsonProperty(value="individualName")
        public IndividualSearchBuilder individualName(String individualName) {
            this.individualName = individualName;
            return this;
        }

        @JsonProperty(value="createdFrom")
        public IndividualSearchBuilder createdFrom(BigDecimal createdFrom) {
            this.createdFrom = createdFrom;
            return this;
        }

        @JsonProperty(value="createdTo")
        public IndividualSearchBuilder createdTo(BigDecimal createdTo) {
            this.createdTo = createdTo;
            return this;
        }

        @JsonProperty(value="identifier")
        public IndividualSearchBuilder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        @JsonProperty(value="boundaryCode")
        public IndividualSearchBuilder boundaryCode(String boundaryCode) {
            this.boundaryCode = boundaryCode;
            return this;
        }

        @JsonProperty(value="roleCodes")
        public IndividualSearchBuilder roleCodes(List<String> roleCodes) {
            this.roleCodes = roleCodes;
            return this;
        }

        @JsonProperty(value="username")
        public IndividualSearchBuilder username(List<String> username) {
            this.username = username;
            return this;
        }

        @JsonProperty(value="userId")
        public IndividualSearchBuilder userId(List<Long> userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="userUuid")
        public IndividualSearchBuilder userUuid(List<String> userUuid) {
            this.userUuid = userUuid;
            return this;
        }

        @JsonProperty(value="type")
        public IndividualSearchBuilder type(String type) {
            this.type = type;
            return this;
        }

        public IndividualSearch build() {
            return new IndividualSearch(this.id, this.individualId, this.clientReferenceId, this.name, this.dateOfBirth, this.gender, this.mobileNumber, this.socialCategory, this.wardCode, this.individualName, this.createdFrom, this.createdTo, this.identifier, this.boundaryCode, this.roleCodes, this.username, this.userId, this.userUuid, this.type);
        }

        public String toString() {
            return "IndividualSearch.IndividualSearchBuilder(id=" + this.id + ", individualId=" + this.individualId + ", clientReferenceId=" + this.clientReferenceId + ", name=" + this.name + ", dateOfBirth=" + this.dateOfBirth + ", gender=" + (Object)((Object)this.gender) + ", mobileNumber=" + this.mobileNumber + ", socialCategory=" + this.socialCategory + ", wardCode=" + this.wardCode + ", individualName=" + this.individualName + ", createdFrom=" + this.createdFrom + ", createdTo=" + this.createdTo + ", identifier=" + this.identifier + ", boundaryCode=" + this.boundaryCode + ", roleCodes=" + this.roleCodes + ", username=" + this.username + ", userId=" + this.userId + ", userUuid=" + this.userUuid + ", type=" + this.type + ")";
        }
    }
}

