/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.individual.Individual;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndividualBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Individual")
    @Valid
    private List<Individual> individual = null;

    public IndividualBulkResponse addIndividualItem(Individual individualItem) {
        if (this.individual == null) {
            this.individual = new ArrayList<Individual>();
        }
        this.individual.add(individualItem);
        return this;
    }

    public static IndividualBulkResponseBuilder builder() {
        return new IndividualBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Individual> getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Individual")
    public void setIndividual(List<Individual> individual) {
        this.individual = individual;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndividualBulkResponse)) {
            return false;
        }
        IndividualBulkResponse other = (IndividualBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Individual> this$individual = this.getIndividual();
        List<Individual> other$individual = other.getIndividual();
        return !(this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndividualBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Individual> $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        return result;
    }

    public String toString() {
        return "IndividualBulkResponse(responseInfo=" + this.getResponseInfo() + ", individual=" + this.getIndividual() + ")";
    }

    public IndividualBulkResponse() {
    }

    public IndividualBulkResponse(ResponseInfo responseInfo, List<Individual> individual) {
        this.responseInfo = responseInfo;
        this.individual = individual;
    }

    public static class IndividualBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Individual> individual;

        IndividualBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public IndividualBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Individual")
        public IndividualBulkResponseBuilder individual(List<Individual> individual) {
            this.individual = individual;
            return this;
        }

        public IndividualBulkResponse build() {
            return new IndividualBulkResponse(this.responseInfo, this.individual);
        }

        public String toString() {
            return "IndividualBulkResponse.IndividualBulkResponseBuilder(responseInfo=" + this.responseInfo + ", individual=" + this.individual + ")";
        }
    }
}

