/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.household.Household;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Households")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Household> households = new ArrayList<Household>();

    public HouseholdBulkRequest addHouseholdItem(Household householdItem) {
        this.households.add(householdItem);
        return this;
    }

    public static HouseholdBulkRequestBuilder builder() {
        return new HouseholdBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Household> getHouseholds() {
        return this.households;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Households")
    public void setHouseholds(List<Household> households) {
        this.households = households;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdBulkRequest)) {
            return false;
        }
        HouseholdBulkRequest other = (HouseholdBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Household> this$households = this.getHouseholds();
        List<Household> other$households = other.getHouseholds();
        return !(this$households == null ? other$households != null : !((Object)this$households).equals(other$households));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Household> $households = this.getHouseholds();
        result = result * 59 + ($households == null ? 43 : ((Object)$households).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdBulkRequest(requestInfo=" + this.getRequestInfo() + ", households=" + this.getHouseholds() + ")";
    }

    public HouseholdBulkRequest() {
    }

    public HouseholdBulkRequest(RequestInfo requestInfo, List<Household> households) {
        this.requestInfo = requestInfo;
        this.households = households;
    }

    public static class HouseholdBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Household> households;

        HouseholdBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HouseholdBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Households")
        public HouseholdBulkRequestBuilder households(List<Household> households) {
            this.households = households;
            return this;
        }

        public HouseholdBulkRequest build() {
            return new HouseholdBulkRequest(this.requestInfo, this.households);
        }

        public String toString() {
            return "HouseholdBulkRequest.HouseholdBulkRequestBuilder(requestInfo=" + this.requestInfo + ", households=" + this.households + ")";
        }
    }
}

