/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.TaskResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskResourceResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Task")
    @NotNull
    @Valid
    private List<TaskResource> resources = new ArrayList<TaskResource>();

    public TaskResourceResponse addTaskResourceItem(TaskResource resourceItem) {
        this.resources.add(resourceItem);
        return this;
    }

    public static TaskResourceResponseBuilder builder() {
        return new TaskResourceResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<TaskResource> getResources() {
        return this.resources;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Task")
    public void setResources(List<TaskResource> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskResourceResponse)) {
            return false;
        }
        TaskResourceResponse other = (TaskResourceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<TaskResource> this$resources = this.getResources();
        List<TaskResource> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskResourceResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<TaskResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    public String toString() {
        return "TaskResourceResponse(responseInfo=" + this.getResponseInfo() + ", resources=" + this.getResources() + ")";
    }

    public TaskResourceResponse() {
    }

    public TaskResourceResponse(ResponseInfo responseInfo, List<TaskResource> resources) {
        this.responseInfo = responseInfo;
        this.resources = resources;
    }

    public static class TaskResourceResponseBuilder {
        private ResponseInfo responseInfo;
        private List<TaskResource> resources;

        TaskResourceResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public TaskResourceResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Task")
        public TaskResourceResponseBuilder resources(List<TaskResource> resources) {
            this.resources = resources;
            return this;
        }

        public TaskResourceResponse build() {
            return new TaskResourceResponse(this.responseInfo, this.resources);
        }

        public String toString() {
            return "TaskResourceResponse.TaskResourceResponseBuilder(responseInfo=" + this.responseInfo + ", resources=" + this.resources + ")";
        }
    }
}

