/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.household.AdditionalFields;
import org.egov.common.models.household.Address;
import org.hibernate.validator.constraints.Range;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of Household.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Household {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String tenantId = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="memberCount")
    @NotNull
    @Range(min=0L, max=10000L)
    private @NotNull @Range(min=0L, max=10000L) Integer memberCount = null;
    @JsonProperty(value="address")
    @Valid
    private Address address = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;

    public static HouseholdBuilder builder() {
        return new HouseholdBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    public Address getAddress() {
        return this.address;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="memberCount")
    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Household)) {
            return false;
        }
        Household other = (Household)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        return !(this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Household;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Household(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", clientReferenceId=" + this.getClientReferenceId() + ", memberCount=" + this.getMemberCount() + ", address=" + this.getAddress() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", auditDetails=" + this.getAuditDetails() + ", clientAuditDetails=" + this.getClientAuditDetails() + ", hasErrors=" + this.getHasErrors() + ")";
    }

    public Household() {
    }

    public Household(String id, String tenantId, String clientReferenceId, Integer memberCount, Address address, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails, AuditDetails clientAuditDetails, Boolean hasErrors) {
        this.id = id;
        this.tenantId = tenantId;
        this.clientReferenceId = clientReferenceId;
        this.memberCount = memberCount;
        this.address = address;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
        this.clientAuditDetails = clientAuditDetails;
        this.hasErrors = hasErrors;
    }

    public static class HouseholdBuilder {
        private String id;
        private String tenantId;
        private String clientReferenceId;
        private Integer memberCount;
        private Address address;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;
        private AuditDetails clientAuditDetails;
        private Boolean hasErrors;

        HouseholdBuilder() {
        }

        @JsonProperty(value="id")
        public HouseholdBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public HouseholdBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public HouseholdBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="memberCount")
        public HouseholdBuilder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        @JsonProperty(value="address")
        public HouseholdBuilder address(Address address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public HouseholdBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public HouseholdBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public HouseholdBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public HouseholdBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public HouseholdBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        @JsonIgnore
        public HouseholdBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public Household build() {
            return new Household(this.id, this.tenantId, this.clientReferenceId, this.memberCount, this.address, this.additionalFields, this.isDeleted, this.rowVersion, this.auditDetails, this.clientAuditDetails, this.hasErrors);
        }

        public String toString() {
            return "Household.HouseholdBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", clientReferenceId=" + this.clientReferenceId + ", memberCount=" + this.memberCount + ", address=" + this.address + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ", clientAuditDetails=" + this.clientAuditDetails + ", hasErrors=" + this.hasErrors + ")";
        }
    }
}

