/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.project.AdditionalFields;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of the registration of an entity to a Project.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectBeneficiary {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="beneficiaryId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String beneficiaryId = null;
    @JsonProperty(value="dateOfRegistration")
    @Min(value=0L, message="Date must be greater than or equal to 0")
    private @Min(value=0L, message="Date must be greater than or equal to 0") Long dateOfRegistration = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="beneficiaryClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String beneficiaryClientReferenceId = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;
    @JsonProperty(value="tag")
    @Size(min=2)
    private @Size(min=2) String tag;

    public static ProjectBeneficiaryBuilder builder() {
        return new ProjectBeneficiaryBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBeneficiaryId() {
        return this.beneficiaryId;
    }

    public Long getDateOfRegistration() {
        return this.dateOfRegistration;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getBeneficiaryClientReferenceId() {
        return this.beneficiaryClientReferenceId;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="beneficiaryId")
    public void setBeneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
    }

    @JsonProperty(value="dateOfRegistration")
    public void setDateOfRegistration(Long dateOfRegistration) {
        this.dateOfRegistration = dateOfRegistration;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="beneficiaryClientReferenceId")
    public void setBeneficiaryClientReferenceId(String beneficiaryClientReferenceId) {
        this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @JsonProperty(value="tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectBeneficiary)) {
            return false;
        }
        ProjectBeneficiary other = (ProjectBeneficiary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$dateOfRegistration = this.getDateOfRegistration();
        Long other$dateOfRegistration = other.getDateOfRegistration();
        if (this$dateOfRegistration == null ? other$dateOfRegistration != null : !((Object)this$dateOfRegistration).equals(other$dateOfRegistration)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$beneficiaryId = this.getBeneficiaryId();
        String other$beneficiaryId = other.getBeneficiaryId();
        if (this$beneficiaryId == null ? other$beneficiaryId != null : !this$beneficiaryId.equals(other$beneficiaryId)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$beneficiaryClientReferenceId = this.getBeneficiaryClientReferenceId();
        String other$beneficiaryClientReferenceId = other.getBeneficiaryClientReferenceId();
        if (this$beneficiaryClientReferenceId == null ? other$beneficiaryClientReferenceId != null : !this$beneficiaryClientReferenceId.equals(other$beneficiaryClientReferenceId)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        if (this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectBeneficiary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $dateOfRegistration = this.getDateOfRegistration();
        result = result * 59 + ($dateOfRegistration == null ? 43 : ((Object)$dateOfRegistration).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $beneficiaryId = this.getBeneficiaryId();
        result = result * 59 + ($beneficiaryId == null ? 43 : $beneficiaryId.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $beneficiaryClientReferenceId = this.getBeneficiaryClientReferenceId();
        result = result * 59 + ($beneficiaryClientReferenceId == null ? 43 : $beneficiaryClientReferenceId.hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectBeneficiary(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", projectId=" + this.getProjectId() + ", beneficiaryId=" + this.getBeneficiaryId() + ", dateOfRegistration=" + this.getDateOfRegistration() + ", clientReferenceId=" + this.getClientReferenceId() + ", beneficiaryClientReferenceId=" + this.getBeneficiaryClientReferenceId() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", auditDetails=" + this.getAuditDetails() + ", clientAuditDetails=" + this.getClientAuditDetails() + ", hasErrors=" + this.getHasErrors() + ", tag=" + this.getTag() + ")";
    }

    public ProjectBeneficiary() {
    }

    public ProjectBeneficiary(String id, String tenantId, String projectId, String beneficiaryId, Long dateOfRegistration, String clientReferenceId, String beneficiaryClientReferenceId, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails, AuditDetails clientAuditDetails, Boolean hasErrors, String tag) {
        this.id = id;
        this.tenantId = tenantId;
        this.projectId = projectId;
        this.beneficiaryId = beneficiaryId;
        this.dateOfRegistration = dateOfRegistration;
        this.clientReferenceId = clientReferenceId;
        this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
        this.clientAuditDetails = clientAuditDetails;
        this.hasErrors = hasErrors;
        this.tag = tag;
    }

    public static class ProjectBeneficiaryBuilder {
        private String id;
        private String tenantId;
        private String projectId;
        private String beneficiaryId;
        private Long dateOfRegistration;
        private String clientReferenceId;
        private String beneficiaryClientReferenceId;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;
        private AuditDetails clientAuditDetails;
        private Boolean hasErrors;
        private String tag;

        ProjectBeneficiaryBuilder() {
        }

        @JsonProperty(value="id")
        public ProjectBeneficiaryBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProjectBeneficiaryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="projectId")
        public ProjectBeneficiaryBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="beneficiaryId")
        public ProjectBeneficiaryBuilder beneficiaryId(String beneficiaryId) {
            this.beneficiaryId = beneficiaryId;
            return this;
        }

        @JsonProperty(value="dateOfRegistration")
        public ProjectBeneficiaryBuilder dateOfRegistration(Long dateOfRegistration) {
            this.dateOfRegistration = dateOfRegistration;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public ProjectBeneficiaryBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="beneficiaryClientReferenceId")
        public ProjectBeneficiaryBuilder beneficiaryClientReferenceId(String beneficiaryClientReferenceId) {
            this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public ProjectBeneficiaryBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public ProjectBeneficiaryBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public ProjectBeneficiaryBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ProjectBeneficiaryBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public ProjectBeneficiaryBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        @JsonIgnore
        public ProjectBeneficiaryBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        @JsonProperty(value="tag")
        public ProjectBeneficiaryBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ProjectBeneficiary build() {
            return new ProjectBeneficiary(this.id, this.tenantId, this.projectId, this.beneficiaryId, this.dateOfRegistration, this.clientReferenceId, this.beneficiaryClientReferenceId, this.additionalFields, this.isDeleted, this.rowVersion, this.auditDetails, this.clientAuditDetails, this.hasErrors, this.tag);
        }

        public String toString() {
            return "ProjectBeneficiary.ProjectBeneficiaryBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", projectId=" + this.projectId + ", beneficiaryId=" + this.beneficiaryId + ", dateOfRegistration=" + this.dateOfRegistration + ", clientReferenceId=" + this.clientReferenceId + ", beneficiaryClientReferenceId=" + this.beneficiaryClientReferenceId + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ", clientAuditDetails=" + this.clientAuditDetails + ", hasErrors=" + this.hasErrors + ", tag=" + this.tag + ")";
        }
    }
}

