/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.household.HouseholdMember;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMemberBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;
    @JsonProperty(value="HouseholdMembers")
    @Valid
    private List<HouseholdMember> householdMembers = null;

    public HouseholdMemberBulkResponse addHouseholdMemberItem(HouseholdMember householdMemberItem) {
        if (this.householdMembers == null) {
            this.householdMembers = new ArrayList<HouseholdMember>();
        }
        this.householdMembers.add(householdMemberItem);
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static HouseholdMemberBulkResponseBuilder builder() {
        return new HouseholdMemberBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<HouseholdMember> getHouseholdMembers() {
        return this.householdMembers;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @JsonProperty(value="HouseholdMembers")
    public void setHouseholdMembers(List<HouseholdMember> householdMembers) {
        this.householdMembers = householdMembers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMemberBulkResponse)) {
            return false;
        }
        HouseholdMemberBulkResponse other = (HouseholdMemberBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<HouseholdMember> this$householdMembers = this.getHouseholdMembers();
        List<HouseholdMember> other$householdMembers = other.getHouseholdMembers();
        return !(this$householdMembers == null ? other$householdMembers != null : !((Object)this$householdMembers).equals(other$householdMembers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMemberBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<HouseholdMember> $householdMembers = this.getHouseholdMembers();
        result = result * 59 + ($householdMembers == null ? 43 : ((Object)$householdMembers).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMemberBulkResponse(responseInfo=" + this.getResponseInfo() + ", totalCount=" + this.getTotalCount() + ", householdMembers=" + this.getHouseholdMembers() + ")";
    }

    public HouseholdMemberBulkResponse() {
        this.totalCount = HouseholdMemberBulkResponse.$default$totalCount();
    }

    public HouseholdMemberBulkResponse(ResponseInfo responseInfo, Long totalCount, List<HouseholdMember> householdMembers) {
        this.responseInfo = responseInfo;
        this.totalCount = totalCount;
        this.householdMembers = householdMembers;
    }

    public static class HouseholdMemberBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private boolean totalCount$set;
        private Long totalCount$value;
        private List<HouseholdMember> householdMembers;

        HouseholdMemberBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public HouseholdMemberBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public HouseholdMemberBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        @JsonProperty(value="HouseholdMembers")
        public HouseholdMemberBulkResponseBuilder householdMembers(List<HouseholdMember> householdMembers) {
            this.householdMembers = householdMembers;
            return this;
        }

        public HouseholdMemberBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = HouseholdMemberBulkResponse.$default$totalCount();
            }
            return new HouseholdMemberBulkResponse(this.responseInfo, totalCount$value, this.householdMembers);
        }

        public String toString() {
            return "HouseholdMemberBulkResponse.HouseholdMemberBulkResponseBuilder(responseInfo=" + this.responseInfo + ", totalCount$value=" + this.totalCount$value + ", householdMembers=" + this.householdMembers + ")";
        }
    }
}

