/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.household.AdditionalFields;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of a household member (already registered as an individual)")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMember {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="householdId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String householdId = null;
    @JsonProperty(value="householdClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String householdClientReferenceId = null;
    @JsonProperty(value="individualId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualId = null;
    @JsonProperty(value="individualClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualClientReferenceId = null;
    @JsonProperty(value="isHeadOfHousehold")
    private Boolean isHeadOfHousehold = false;
    @JsonProperty(value="tenantId")
    @Size(min=2, max=1000)
    @NotNull
    private @Size(min=2, max=1000) @NotNull String tenantId = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;

    public static HouseholdMemberBuilder builder() {
        return new HouseholdMemberBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getHouseholdId() {
        return this.householdId;
    }

    public String getHouseholdClientReferenceId() {
        return this.householdClientReferenceId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getIndividualClientReferenceId() {
        return this.individualClientReferenceId;
    }

    public Boolean getIsHeadOfHousehold() {
        return this.isHeadOfHousehold;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="householdId")
    public void setHouseholdId(String householdId) {
        this.householdId = householdId;
    }

    @JsonProperty(value="householdClientReferenceId")
    public void setHouseholdClientReferenceId(String householdClientReferenceId) {
        this.householdClientReferenceId = householdClientReferenceId;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="individualClientReferenceId")
    public void setIndividualClientReferenceId(String individualClientReferenceId) {
        this.individualClientReferenceId = individualClientReferenceId;
    }

    @JsonProperty(value="isHeadOfHousehold")
    public void setIsHeadOfHousehold(Boolean isHeadOfHousehold) {
        this.isHeadOfHousehold = isHeadOfHousehold;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMember)) {
            return false;
        }
        HouseholdMember other = (HouseholdMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isHeadOfHousehold = this.getIsHeadOfHousehold();
        Boolean other$isHeadOfHousehold = other.getIsHeadOfHousehold();
        if (this$isHeadOfHousehold == null ? other$isHeadOfHousehold != null : !((Object)this$isHeadOfHousehold).equals(other$isHeadOfHousehold)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$householdId = this.getHouseholdId();
        String other$householdId = other.getHouseholdId();
        if (this$householdId == null ? other$householdId != null : !this$householdId.equals(other$householdId)) {
            return false;
        }
        String this$householdClientReferenceId = this.getHouseholdClientReferenceId();
        String other$householdClientReferenceId = other.getHouseholdClientReferenceId();
        if (this$householdClientReferenceId == null ? other$householdClientReferenceId != null : !this$householdClientReferenceId.equals(other$householdClientReferenceId)) {
            return false;
        }
        String this$individualId = this.getIndividualId();
        String other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !this$individualId.equals(other$individualId)) {
            return false;
        }
        String this$individualClientReferenceId = this.getIndividualClientReferenceId();
        String other$individualClientReferenceId = other.getIndividualClientReferenceId();
        if (this$individualClientReferenceId == null ? other$individualClientReferenceId != null : !this$individualClientReferenceId.equals(other$individualClientReferenceId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        return !(this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isHeadOfHousehold = this.getIsHeadOfHousehold();
        result = result * 59 + ($isHeadOfHousehold == null ? 43 : ((Object)$isHeadOfHousehold).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $householdId = this.getHouseholdId();
        result = result * 59 + ($householdId == null ? 43 : $householdId.hashCode());
        String $householdClientReferenceId = this.getHouseholdClientReferenceId();
        result = result * 59 + ($householdClientReferenceId == null ? 43 : $householdClientReferenceId.hashCode());
        String $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : $individualId.hashCode());
        String $individualClientReferenceId = this.getIndividualClientReferenceId();
        result = result * 59 + ($individualClientReferenceId == null ? 43 : $individualClientReferenceId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMember(id=" + this.getId() + ", householdId=" + this.getHouseholdId() + ", householdClientReferenceId=" + this.getHouseholdClientReferenceId() + ", individualId=" + this.getIndividualId() + ", individualClientReferenceId=" + this.getIndividualClientReferenceId() + ", isHeadOfHousehold=" + this.getIsHeadOfHousehold() + ", tenantId=" + this.getTenantId() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", auditDetails=" + this.getAuditDetails() + ", clientAuditDetails=" + this.getClientAuditDetails() + ", hasErrors=" + this.getHasErrors() + ")";
    }

    public HouseholdMember() {
    }

    public HouseholdMember(String id, String householdId, String householdClientReferenceId, String individualId, String individualClientReferenceId, Boolean isHeadOfHousehold, String tenantId, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails, AuditDetails clientAuditDetails, Boolean hasErrors) {
        this.id = id;
        this.householdId = householdId;
        this.householdClientReferenceId = householdClientReferenceId;
        this.individualId = individualId;
        this.individualClientReferenceId = individualClientReferenceId;
        this.isHeadOfHousehold = isHeadOfHousehold;
        this.tenantId = tenantId;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
        this.clientAuditDetails = clientAuditDetails;
        this.hasErrors = hasErrors;
    }

    public static class HouseholdMemberBuilder {
        private String id;
        private String householdId;
        private String householdClientReferenceId;
        private String individualId;
        private String individualClientReferenceId;
        private Boolean isHeadOfHousehold;
        private String tenantId;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;
        private AuditDetails clientAuditDetails;
        private Boolean hasErrors;

        HouseholdMemberBuilder() {
        }

        @JsonProperty(value="id")
        public HouseholdMemberBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="householdId")
        public HouseholdMemberBuilder householdId(String householdId) {
            this.householdId = householdId;
            return this;
        }

        @JsonProperty(value="householdClientReferenceId")
        public HouseholdMemberBuilder householdClientReferenceId(String householdClientReferenceId) {
            this.householdClientReferenceId = householdClientReferenceId;
            return this;
        }

        @JsonProperty(value="individualId")
        public HouseholdMemberBuilder individualId(String individualId) {
            this.individualId = individualId;
            return this;
        }

        @JsonProperty(value="individualClientReferenceId")
        public HouseholdMemberBuilder individualClientReferenceId(String individualClientReferenceId) {
            this.individualClientReferenceId = individualClientReferenceId;
            return this;
        }

        @JsonProperty(value="isHeadOfHousehold")
        public HouseholdMemberBuilder isHeadOfHousehold(Boolean isHeadOfHousehold) {
            this.isHeadOfHousehold = isHeadOfHousehold;
            return this;
        }

        @JsonProperty(value="tenantId")
        public HouseholdMemberBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public HouseholdMemberBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public HouseholdMemberBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public HouseholdMemberBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public HouseholdMemberBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public HouseholdMemberBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        @JsonIgnore
        public HouseholdMemberBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public HouseholdMember build() {
            return new HouseholdMember(this.id, this.householdId, this.householdClientReferenceId, this.individualId, this.individualClientReferenceId, this.isHeadOfHousehold, this.tenantId, this.additionalFields, this.isDeleted, this.rowVersion, this.auditDetails, this.clientAuditDetails, this.hasErrors);
        }

        public String toString() {
            return "HouseholdMember.HouseholdMemberBuilder(id=" + this.id + ", householdId=" + this.householdId + ", householdClientReferenceId=" + this.householdClientReferenceId + ", individualId=" + this.individualId + ", individualClientReferenceId=" + this.individualClientReferenceId + ", isHeadOfHousehold=" + this.isHeadOfHousehold + ", tenantId=" + this.tenantId + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ", clientAuditDetails=" + this.clientAuditDetails + ", hasErrors=" + this.hasErrors + ")";
        }
    }
}

