/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ApiOperation;
import org.egov.common.models.project.TaskResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskResourceRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Task")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<TaskResource> resources = new ArrayList<TaskResource>();
    @JsonProperty(value="apiOperation")
    @Valid
    private ApiOperation apiOperation = null;

    public TaskResourceRequest addTaskItem(TaskResource resourceItem) {
        this.resources.add(resourceItem);
        return this;
    }

    public static TaskResourceRequestBuilder builder() {
        return new TaskResourceRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<TaskResource> getResources() {
        return this.resources;
    }

    public ApiOperation getApiOperation() {
        return this.apiOperation;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Task")
    public void setResources(List<TaskResource> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="apiOperation")
    public void setApiOperation(ApiOperation apiOperation) {
        this.apiOperation = apiOperation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskResourceRequest)) {
            return false;
        }
        TaskResourceRequest other = (TaskResourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<TaskResource> this$resources = this.getResources();
        List<TaskResource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        ApiOperation this$apiOperation = this.getApiOperation();
        ApiOperation other$apiOperation = other.getApiOperation();
        return !(this$apiOperation == null ? other$apiOperation != null : !((Object)((Object)this$apiOperation)).equals((Object)other$apiOperation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskResourceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<TaskResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        ApiOperation $apiOperation = this.getApiOperation();
        result = result * 59 + ($apiOperation == null ? 43 : ((Object)((Object)$apiOperation)).hashCode());
        return result;
    }

    public String toString() {
        return "TaskResourceRequest(requestInfo=" + this.getRequestInfo() + ", resources=" + this.getResources() + ", apiOperation=" + (Object)((Object)this.getApiOperation()) + ")";
    }

    public TaskResourceRequest() {
    }

    public TaskResourceRequest(RequestInfo requestInfo, List<TaskResource> resources, ApiOperation apiOperation) {
        this.requestInfo = requestInfo;
        this.resources = resources;
        this.apiOperation = apiOperation;
    }

    public static class TaskResourceRequestBuilder {
        private RequestInfo requestInfo;
        private List<TaskResource> resources;
        private ApiOperation apiOperation;

        TaskResourceRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public TaskResourceRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Task")
        public TaskResourceRequestBuilder resources(List<TaskResource> resources) {
            this.resources = resources;
            return this;
        }

        @JsonProperty(value="apiOperation")
        public TaskResourceRequestBuilder apiOperation(ApiOperation apiOperation) {
            this.apiOperation = apiOperation;
            return this;
        }

        public TaskResourceRequest build() {
            return new TaskResourceRequest(this.requestInfo, this.resources, this.apiOperation);
        }

        public String toString() {
            return "TaskResourceRequest.TaskResourceRequestBuilder(requestInfo=" + this.requestInfo + ", resources=" + this.resources + ", apiOperation=" + (Object)((Object)this.apiOperation) + ")";
        }
    }
}

