/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.product.ProductSearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductSearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Product")
    @NotNull
    @Valid
    private ProductSearch product = null;

    public static ProductSearchRequestBuilder builder() {
        return new ProductSearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public ProductSearch getProduct() {
        return this.product;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Product")
    public void setProduct(ProductSearch product) {
        this.product = product;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductSearchRequest)) {
            return false;
        }
        ProductSearchRequest other = (ProductSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        ProductSearch this$product = this.getProduct();
        ProductSearch other$product = other.getProduct();
        return !(this$product == null ? other$product != null : !((Object)this$product).equals(other$product));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        ProductSearch $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        return result;
    }

    public String toString() {
        return "ProductSearchRequest(requestInfo=" + this.getRequestInfo() + ", product=" + this.getProduct() + ")";
    }

    public ProductSearchRequest() {
    }

    public ProductSearchRequest(RequestInfo requestInfo, ProductSearch product) {
        this.requestInfo = requestInfo;
        this.product = product;
    }

    public static class ProductSearchRequestBuilder {
        private RequestInfo requestInfo;
        private ProductSearch product;

        ProductSearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProductSearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Product")
        public ProductSearchRequestBuilder product(ProductSearch product) {
            this.product = product;
            return this;
        }

        public ProductSearchRequest build() {
            return new ProductSearchRequest(this.requestInfo, this.product);
        }

        public String toString() {
            return "ProductSearchRequest.ProductSearchRequestBuilder(requestInfo=" + this.requestInfo + ", product=" + this.product + ")";
        }
    }
}

