/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import org.egov.common.models.individual.Gender;
import org.egov.common.models.individual.Identifier;
import org.egov.common.models.individual.Name;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndividualSearch {
    @JsonProperty(value="id")
    private List<String> id = null;
    @JsonProperty(value="clientReferenceId")
    private List<String> clientReferenceId = null;
    @JsonProperty(value="name")
    @Valid
    private Name name = null;
    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    private LocalDate dateOfBirth = null;
    @JsonProperty(value="gender")
    @Valid
    private Gender gender = null;
    @JsonProperty(value="identifier")
    @Valid
    private Identifier identifier = null;
    @JsonProperty(value="boundaryCode")
    private String boundaryCode = null;

    public static IndividualSearchBuilder builder() {
        return new IndividualSearchBuilder();
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getClientReferenceId() {
        return this.clientReferenceId;
    }

    public Name getName() {
        return this.name;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getBoundaryCode() {
        return this.boundaryCode;
    }

    @JsonProperty(value="id")
    public void setId(List<String> id) {
        this.id = id;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(List<String> clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="gender")
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="boundaryCode")
    public void setBoundaryCode(String boundaryCode) {
        this.boundaryCode = boundaryCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndividualSearch)) {
            return false;
        }
        IndividualSearch other = (IndividualSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$id = this.getId();
        List<String> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<String> this$clientReferenceId = this.getClientReferenceId();
        List<String> other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !((Object)this$clientReferenceId).equals(other$clientReferenceId)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        LocalDate this$dateOfBirth = this.getDateOfBirth();
        LocalDate other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        Identifier this$identifier = this.getIdentifier();
        Identifier other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        String this$boundaryCode = this.getBoundaryCode();
        String other$boundaryCode = other.getBoundaryCode();
        return !(this$boundaryCode == null ? other$boundaryCode != null : !this$boundaryCode.equals(other$boundaryCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndividualSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<String> $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : ((Object)$clientReferenceId).hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        LocalDate $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        Identifier $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        String $boundaryCode = this.getBoundaryCode();
        result = result * 59 + ($boundaryCode == null ? 43 : $boundaryCode.hashCode());
        return result;
    }

    public String toString() {
        return "IndividualSearch(id=" + this.getId() + ", clientReferenceId=" + this.getClientReferenceId() + ", name=" + this.getName() + ", dateOfBirth=" + this.getDateOfBirth() + ", gender=" + (Object)((Object)this.getGender()) + ", identifier=" + this.getIdentifier() + ", boundaryCode=" + this.getBoundaryCode() + ")";
    }

    public IndividualSearch() {
    }

    public IndividualSearch(List<String> id, List<String> clientReferenceId, Name name, LocalDate dateOfBirth, Gender gender, Identifier identifier, String boundaryCode) {
        this.id = id;
        this.clientReferenceId = clientReferenceId;
        this.name = name;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.identifier = identifier;
        this.boundaryCode = boundaryCode;
    }

    public static class IndividualSearchBuilder {
        private List<String> id;
        private List<String> clientReferenceId;
        private Name name;
        private LocalDate dateOfBirth;
        private Gender gender;
        private Identifier identifier;
        private String boundaryCode;

        IndividualSearchBuilder() {
        }

        @JsonProperty(value="id")
        public IndividualSearchBuilder id(List<String> id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public IndividualSearchBuilder clientReferenceId(List<String> clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="name")
        public IndividualSearchBuilder name(Name name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="dateOfBirth")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
        public IndividualSearchBuilder dateOfBirth(LocalDate dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        @JsonProperty(value="gender")
        public IndividualSearchBuilder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        @JsonProperty(value="identifier")
        public IndividualSearchBuilder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        @JsonProperty(value="boundaryCode")
        public IndividualSearchBuilder boundaryCode(String boundaryCode) {
            this.boundaryCode = boundaryCode;
            return this;
        }

        public IndividualSearch build() {
            return new IndividualSearch(this.id, this.clientReferenceId, this.name, this.dateOfBirth, this.gender, this.identifier, this.boundaryCode);
        }

        public String toString() {
            return "IndividualSearch.IndividualSearchBuilder(id=" + this.id + ", clientReferenceId=" + this.clientReferenceId + ", name=" + this.name + ", dateOfBirth=" + this.dateOfBirth + ", gender=" + (Object)((Object)this.gender) + ", identifier=" + this.identifier + ", boundaryCode=" + this.boundaryCode + ")";
        }
    }
}

