/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.service;

import org.egov.common.http.client.ServiceRequestClient;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
@ConditionalOnExpression(value="!'${egov.mdms.integration.enabled}'.isEmpty() && ${egov.mdms.integration.enabled:false} && !'${egov.mdms.host}'.isEmpty() && !'${egov.mdms.search.endpoint}'.isEmpty()")
public class MdmsService {
    private static final Logger log = LoggerFactory.getLogger(MdmsService.class);
    private final ServiceRequestClient restRepo;
    private final String mdmsHost;
    private final String mdmsUrl;

    @Autowired
    public MdmsService(ServiceRequestClient restRepo, @Value(value="${egov.mdms.host}") String mdmsHost, @Value(value="${egov.mdms.search.endpoint}") String mdmsUrl) {
        this.restRepo = restRepo;
        this.mdmsHost = mdmsHost;
        this.mdmsUrl = mdmsUrl;
    }

    public <T> T fetchConfig(Object request, Class<T> clazz) throws Exception {
        T response;
        try {
            response = this.restRepo.fetchResult(new StringBuilder(this.mdmsHost + this.mdmsUrl), request, clazz);
        }
        catch (HttpClientErrorException e) {
            throw new CustomException("HTTP_CLIENT_ERROR", String.format("%s - %s", e.getMessage(), e.getResponseBodyAsString()));
        }
        return response;
    }
}

