/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Repository
public class ServiceRequestClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceRequestClient.class);
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    @Autowired
    public ServiceRequestClient(@Qualifier(value="objectMapper") ObjectMapper objectMapper, RestTemplate restTemplate) {
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    public <T> T fetchResult(StringBuilder uri, Object request, Class<T> clazz) {
        Object response;
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            response = this.restTemplate.postForObject(uri.toString(), request, clazz, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new CustomException("HTTP_CLIENT_ERROR", String.format("%s - %s", e.getMessage(), e.getResponseBodyAsString()));
        }
        catch (Exception exception) {
            throw new CustomException("SERVICE_REQUEST_CLIENT_ERROR", exception.getMessage());
        }
        return (T)response;
    }
}

