/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.utils;

import digit.models.coremodels.AuditDetails;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.egov.common.contract.request.RequestInfo;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String GET_API_OPERATION = "getApiOperation";
    private static final Map<Class<?>, Map<String, Method>> methodCache = new HashMap();

    private CommonUtils() {
    }

    public static boolean isForUpdate(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        return "UPDATE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation));
    }

    public static boolean isForDelete(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        return "DELETE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation));
    }

    public static boolean isForCreate(Object obj) {
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, obj.getClass());
        Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)obj);
        if (apiOperation == null) {
            return false;
        }
        Method nameMethod = CommonUtils.getMethod("name", Enum.class);
        String value = (String)ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation);
        return "CREATE".equals(value);
    }

    public static <T, R> Set<T> getSet(List<R> objects, String methodName) {
        return objects.stream().map(o -> ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod(methodName, o.getClass()), (Object)o)).collect(Collectors.toSet());
    }

    public static <T> List<T> getDifference(List<T> list, List<T> subList) {
        ArrayList<T> newList = new ArrayList<T>(list);
        ArrayList<T> newSubList = new ArrayList<T>(subList);
        if (newList.size() >= newSubList.size()) {
            newList.removeAll(subList);
        }
        return newList;
    }

    public static <T> void validateIds(Set<T> idsToValidate, UnaryOperator<List<T>> validator) {
        ArrayList<T> idsToValidateList = new ArrayList<T>(idsToValidate);
        List validIds = (List)validator.apply(idsToValidateList);
        List<T> invalidIds = CommonUtils.getDifference(idsToValidateList, validIds);
        if (!invalidIds.isEmpty()) {
            log.error("Invalid IDs {}", invalidIds);
            throw new CustomException("INVALID_ID", invalidIds.toString());
        }
    }

    public static AuditDetails getAuditDetailsForCreate(RequestInfo requestInfo) {
        log.info("Creating audit details for create api");
        Long time = System.currentTimeMillis();
        return AuditDetails.builder().createdBy(requestInfo.getUserInfo().getUuid()).createdTime(time).lastModifiedBy(requestInfo.getUserInfo().getUuid()).lastModifiedTime(time).build();
    }

    public static AuditDetails getAuditDetailsForUpdate(AuditDetails existingAuditDetails, String modifiedByUuid) {
        log.info("Creating audit details for update api");
        return AuditDetails.builder().createdBy(existingAuditDetails.getCreatedBy()).createdTime(existingAuditDetails.getCreatedTime()).lastModifiedBy(modifiedByUuid).lastModifiedTime(Long.valueOf(System.currentTimeMillis())).build();
    }

    public static boolean isSearchByIdOnly(Object obj) {
        return CommonUtils.isSearchByIdOnly(obj, "id");
    }

    public static boolean isSearchByIdOnly(Object obj, String fieldName) {
        Class<?> objClass = obj.getClass();
        String propertyName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method setIdMethod = CommonUtils.getMethod("set" + propertyName, objClass);
        Method getIdMethod = CommonUtils.getMethod("get" + propertyName, objClass);
        Object finalObject = null;
        try {
            finalObject = objClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        Object id = ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)obj);
        ReflectionUtils.invokeMethod((Method)setIdMethod, finalObject, (Object[])new Object[]{id});
        if (id == null) {
            return false;
        }
        String actual = obj.toString();
        String expected = finalObject.toString();
        return actual.equals(expected);
    }

    public static <T> void checkRowVersion(Map<String, T> idToObjMap, List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        CommonUtils.checkRowVersion(idToObjMap, objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> void checkRowVersion(Map<String, T> idToObjMap, List<T> objList, Method idMethod) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method rowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        Set rowVersionMismatch = objList.stream().filter(obj -> !Objects.equals(ReflectionUtils.invokeMethod((Method)rowVersionMethod, (Object)obj), ReflectionUtils.invokeMethod((Method)rowVersionMethod, idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj))))).map(obj -> ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toSet());
        if (!rowVersionMismatch.isEmpty()) {
            log.error("Mismatch in row versions {}", rowVersionMismatch);
            throw new CustomException("ROW_VERSION_MISMATCH", rowVersionMismatch.toString());
        }
    }

    public static <T> String getTenantId(List<T> objList) {
        Object obj = objList.stream().findAny().get();
        Method getTenantIdMethod = CommonUtils.getMethod("getTenantId", obj.getClass());
        String tenantId = (String)ReflectionUtils.invokeMethod((Method)getTenantIdMethod, obj);
        log.info("Tenant ID {}", (Object)tenantId);
        return tenantId;
    }

    public static <T> void enrichForCreate(List<T> objList, List<String> idList, RequestInfo requestInfo) {
        AuditDetails auditDetails = CommonUtils.getAuditDetailsForCreate(requestInfo);
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method setIdMethod = CommonUtils.getMethod("setId", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
        Method setIsDeletedMethod = CommonUtils.getMethod("setIsDeleted", objClass);
        IntStream.range(0, objList.size()).forEach(i -> {
            Object obj = objList.get(i);
            ReflectionUtils.invokeMethod((Method)setIdMethod, obj, (Object[])new Object[]{idList.get(i)});
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, obj, (Object[])new Object[]{auditDetails});
            ReflectionUtils.invokeMethod((Method)setRowVersionMethod, obj, (Object[])new Object[]{1});
            ReflectionUtils.invokeMethod((Method)setIsDeletedMethod, obj, (Object[])new Object[]{Boolean.FALSE});
        });
    }

    public static <T> Method getIdMethod(List<T> objList) {
        return CommonUtils.getIdMethod(objList, "id", "clientReferenceId");
    }

    public static <T> Method getIdMethod(List<T> objList, String idFieldName) {
        String idMethodName = "get" + idFieldName.substring(0, 1).toUpperCase() + idFieldName.substring(1);
        return CommonUtils.getMethod(idMethodName, CommonUtils.getObjClass(objList));
    }

    public static <T> Method getIdMethod(List<T> objList, String idField, String clientReferenceIdField) {
        String idMethodName = "get" + idField.substring(0, 1).toUpperCase() + idField.substring(1);
        String clientReferenceIdMethodName = "get" + clientReferenceIdField.substring(0, 1).toUpperCase() + clientReferenceIdField.substring(1);
        try {
            Method getId = CommonUtils.getMethod(idMethodName, CommonUtils.getObjClass(objList));
            String value = (String)ReflectionUtils.invokeMethod((Method)getId, objList.stream().findAny().get());
            if (value != null) {
                return getId;
            }
        }
        catch (CustomException e) {
            log.error(e.getMessage());
        }
        return CommonUtils.getMethod(clientReferenceIdMethodName, CommonUtils.getObjClass(objList));
    }

    public static <T> void enrichId(List<T> objList, List<String> idList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        Method setIdMethod = CommonUtils.getMethod("setId", objClass);
        IntStream.range(0, objList.size()).forEach(i -> {
            Object obj = objList.get(i);
            ReflectionUtils.invokeMethod((Method)setIdMethod, obj, (Object[])new Object[]{idList.get(i)});
        });
    }

    public static <T> void enrichForUpdate(Map<String, T> idToObjMap, List<T> existingObjList, Object request) {
        Class<?> objClass = CommonUtils.getObjClass(existingObjList);
        CommonUtils.enrichForUpdate(idToObjMap, existingObjList, request, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> void enrichForUpdate(Map<String, T> idToObjMap, List<T> existingObjList, Object request, Method idMethod) {
        Class<?> objClass = CommonUtils.getObjClass(existingObjList);
        Class<?> requestObjClass = request.getClass();
        Method setIsDeletedMethod = CommonUtils.getMethod("setIsDeleted", objClass);
        Method getRowVersionMethod = CommonUtils.getMethod("getRowVersion", objClass);
        Method setRowVersionMethod = CommonUtils.getMethod("setRowVersion", objClass);
        Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", objClass);
        Method setAuditDetailsMethod = CommonUtils.getMethod("setAuditDetails", objClass);
        Method getApiOperationMethod = CommonUtils.getMethod(GET_API_OPERATION, requestObjClass);
        Method getRequestInfoMethod = CommonUtils.getMethod("getRequestInfo", requestObjClass);
        IntStream.range(0, existingObjList.size()).forEach(i -> {
            Object obj = idToObjMap.get(ReflectionUtils.invokeMethod((Method)idMethod, existingObjList.get(i)));
            Object apiOperation = ReflectionUtils.invokeMethod((Method)getApiOperationMethod, (Object)request);
            Method nameMethod = CommonUtils.getMethod("name", Enum.class);
            if ("DELETE".equals(ReflectionUtils.invokeMethod((Method)nameMethod, (Object)apiOperation))) {
                ReflectionUtils.invokeMethod((Method)setIsDeletedMethod, obj, (Object[])new Object[]{true});
            }
            Integer rowVersion = (Integer)ReflectionUtils.invokeMethod((Method)getRowVersionMethod, obj);
            ReflectionUtils.invokeMethod((Method)setRowVersionMethod, obj, (Object[])new Object[]{rowVersion + 1});
            RequestInfo requestInfo = (RequestInfo)ReflectionUtils.invokeMethod((Method)getRequestInfoMethod, (Object)request);
            AuditDetails existingAuditDetails = (AuditDetails)ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, existingObjList.get(i));
            AuditDetails auditDetailsForUpdate = CommonUtils.getAuditDetailsForUpdate(existingAuditDetails, requestInfo.getUserInfo().getUuid());
            ReflectionUtils.invokeMethod((Method)setAuditDetailsMethod, obj, (Object[])new Object[]{auditDetailsForUpdate});
        });
    }

    public static <T> Map<String, T> getIdToObjMap(List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        return CommonUtils.getIdToObjMap(objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> Map<String, T> getIdToObjMap(List<T> objList, Method idMethod) {
        return objList.stream().collect(Collectors.toMap(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj), obj -> obj));
    }

    public static <T> void validateEntities(Map<String, T> idToObjInRequestMap, List<T> objInDbList) {
        if (idToObjInRequestMap.size() > objInDbList.size()) {
            List<String> idsForObjInDb = CommonUtils.getIdList(objInDbList);
            List idsForInvalidObj = idToObjInRequestMap.keySet().stream().filter(id -> !idsForObjInDb.contains(id)).collect(Collectors.toList());
            log.error("Invalid entities {}", idsForInvalidObj);
            throw new CustomException("INVALID_ENTITY", idsForInvalidObj.toString());
        }
    }

    public static <T> void validateEntities(Map<String, T> idToObjInRequestMap, List<T> objInDbList, Method idMethod) {
        if (idToObjInRequestMap.size() > objInDbList.size()) {
            List<String> idsForObjInDb = CommonUtils.getIdList(objInDbList, idMethod);
            List idsForInvalidObj = idToObjInRequestMap.keySet().stream().filter(id -> !idsForObjInDb.contains(id)).collect(Collectors.toList());
            log.error("Invalid entities {}", idsForInvalidObj);
            throw new CustomException("INVALID_ENTITY", idsForInvalidObj.toString());
        }
    }

    public static <T> List<String> getIdList(List<T> objList) {
        if (objList == null || objList.isEmpty()) {
            return Collections.emptyList();
        }
        Class<?> objClass = CommonUtils.getObjClass(objList);
        return CommonUtils.getIdList(objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> List<String> getIdList(List<T> objList, Method idMethod) {
        if (objList == null || objList.isEmpty()) {
            return Collections.emptyList();
        }
        return objList.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList());
    }

    public static <T> Predicate<T> lastChangedSince(Long lastChangedSince) {
        if (lastChangedSince == null) {
            return obj -> true;
        }
        return obj -> {
            Method getAuditDetailsMethod = CommonUtils.getMethod("getAuditDetails", obj.getClass());
            Object auditDetails = ReflectionUtils.invokeMethod((Method)getAuditDetailsMethod, (Object)obj);
            Method getLastModifiedTimeMethod = CommonUtils.getMethod("getLastModifiedTime", auditDetails.getClass());
            Long lastModifiedTime = (Long)ReflectionUtils.invokeMethod((Method)getLastModifiedTimeMethod, (Object)auditDetails);
            return lastModifiedTime > lastChangedSince;
        };
    }

    public static <T> Predicate<T> includeDeleted(Boolean includeDeleted) {
        if (includeDeleted == null || !includeDeleted.booleanValue()) {
            return obj -> {
                Method getIsDeletedMethod = CommonUtils.getMethod("getIsDeleted", obj.getClass());
                Boolean isDeleted = (Boolean)ReflectionUtils.invokeMethod((Method)getIsDeletedMethod, (Object)obj);
                return Objects.equals(isDeleted, false);
            };
        }
        return obj -> true;
    }

    public static <T> Predicate<T> havingTenantId(String tenantId) {
        if (tenantId == null) {
            return obj -> true;
        }
        return obj -> {
            Method getTenantIdMethod = CommonUtils.getMethod("getTenantId", obj.getClass());
            String actualTenantId = (String)ReflectionUtils.invokeMethod((Method)getTenantIdMethod, (Object)obj);
            return Objects.equals(actualTenantId, tenantId);
        };
    }

    public static <T> Class<?> getObjClass(List<T> objList) {
        return objList.stream().findAny().get().getClass();
    }

    public static <T> void identifyNullIds(List<T> objList) {
        Class<?> objClass = CommonUtils.getObjClass(objList);
        CommonUtils.identifyNullIds(objList, CommonUtils.getMethod("getId", objClass));
    }

    public static <T> void identifyNullIds(List<T> objList, Method idMethod) {
        Long nullCount = objList.stream().filter(obj -> null == ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).count();
        if (nullCount > 0L) {
            throw new CustomException("NULL_ID", String.format("Ids cannot be null, found %d", nullCount));
        }
    }

    public static <T, R> List<R> collectFromList(List<T> objList, Function<T, List<R>> function) {
        return objList.stream().flatMap(obj -> {
            List aList = (List)function.apply(obj);
            if (aList == null || aList.isEmpty()) {
                return new ArrayList().stream();
            }
            return aList.stream();
        }).collect(Collectors.toList());
    }

    public static String getIdFieldName(Object obj) {
        String defaultVal = "id";
        try {
            Field idField = obj.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            Object idFieldValue = idField.get(obj);
            if (idFieldValue != null) {
                return "id";
            }
            Field clientReferenceIdField = obj.getClass().getDeclaredField("clientReferenceId");
            clientReferenceIdField.setAccessible(true);
            Object clientReferenceIdFieldValue = clientReferenceIdField.get(obj);
            if (clientReferenceIdFieldValue != null) {
                return "clientReferenceId";
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return defaultVal;
        }
        return defaultVal;
    }

    public static String getIdFieldName(Method method) {
        if (method != null) {
            return method.getName().contains("Reference") ? "clientReferenceId" : "id";
        }
        return "id";
    }

    public static <T> void enrichIdsFromExistingEntities(Map<String, T> idToObjMap, List<T> existingEntities, Method idMethod) {
        IntStream.range(0, existingEntities.size()).forEach(i -> {
            Object existing = existingEntities.get(i);
            String id = (String)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getId", existing.getClass()), existing);
            String clientReferenceId = (String)ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("getClientReferenceId", existing.getClass()), existing);
            String key = CommonUtils.getIdFieldName(idMethod).equalsIgnoreCase("id") ? id : clientReferenceId;
            Object toUpdate = idToObjMap.get(key);
            ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setId", toUpdate.getClass()), toUpdate, (Object[])new Object[]{id});
            ReflectionUtils.invokeMethod((Method)CommonUtils.getMethod("setClientReferenceId", toUpdate.getClass()), toUpdate, (Object[])new Object[]{clientReferenceId});
        });
    }

    public static Function<Integer, List<String>> uuidSupplier() {
        return integer -> {
            ArrayList<String> uuidList = new ArrayList<String>();
            for (int i = 0; i < integer; ++i) {
                uuidList.add(UUID.randomUUID().toString());
            }
            return uuidList;
        };
    }

    public static Method getMethod(String methodName, Class<?> clazz) {
        if (methodCache.containsKey(clazz)) {
            Map<String, Method> methodMap = methodCache.get(clazz);
            if (methodMap.containsKey(methodName)) {
                return methodMap.get(methodName);
            }
            Method method = CommonUtils.findMethod(methodName, clazz);
            methodMap.put(methodName, method);
            return method;
        }
        Method method = CommonUtils.findMethod(methodName, clazz);
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        methodMap.put(methodName, method);
        methodCache.put(clazz, methodMap);
        return method;
    }

    private static Method findMethod(String methodName, Class<?> clazz) {
        return Arrays.stream(ReflectionUtils.getDeclaredMethods(clazz)).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new CustomException("INVALID_OBJECT_OR_METHOD", "Invalid object or method"));
    }
}

