/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.repository;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.egov.common.data.query.builder.SelectQueryBuilder;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.egov.common.producer.Producer;
import org.egov.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.ReflectionUtils;

public abstract class GenericRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(GenericRepository.class);
    protected final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected final Producer producer;
    protected final RedisTemplate<String, Object> redisTemplate;
    protected final SelectQueryBuilder selectQueryBuilder;
    protected final RowMapper<T> rowMapper;
    protected String tableName;
    @Value(value="${spring.cache.redis.time-to-live:60}")
    private String timeToLive;

    protected GenericRepository(Producer producer, NamedParameterJdbcTemplate namedParameterJdbcTemplate, RedisTemplate<String, Object> redisTemplate, SelectQueryBuilder selectQueryBuilder, RowMapper<T> rowMapper, Optional<String> tableName) {
        this.producer = producer;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.redisTemplate = redisTemplate;
        this.selectQueryBuilder = selectQueryBuilder;
        this.rowMapper = rowMapper;
        tableName.ifPresent(tb -> {
            this.tableName = tb;
        });
    }

    public List<T> findById(List<String> ids) {
        return this.findById(ids, false);
    }

    public List<T> findById(List<String> ids, Boolean includeDeleted) {
        ArrayList objFound = new ArrayList();
        ArrayList<String> collection = new ArrayList<String>(ids);
        List objFromCache = this.redisTemplate.opsForHash().multiGet((Object)this.tableName, collection);
        if (!objFromCache.isEmpty() && !objFromCache.contains(null)) {
            log.info("Cache hit");
            objFound = (ArrayList)objFromCache.stream().map(Object.class::cast).collect(Collectors.toList());
            Method getIdMethod = CommonUtils.getMethod("getId", CommonUtils.getObjClass(objFromCache));
            ids.removeAll(objFound.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)obj)).collect(Collectors.toList()));
            if (ids.isEmpty()) {
                return objFound;
            }
        }
        String query = String.format("SELECT * FROM %s WHERE id IN (:ids) AND isDeleted = false", this.tableName);
        if (null != includeDeleted && includeDeleted.booleanValue()) {
            query = String.format("SELECT * FROM %s WHERE id IN (:ids)", this.tableName);
        }
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("ids", ids);
        objFound.addAll(this.namedParameterJdbcTemplate.query(query, paramMap, this.rowMapper));
        this.putInCache(objFound);
        return objFound;
    }

    public List<T> save(List<T> objects, String topic) {
        this.producer.push(topic, objects);
        log.info("Pushed to kafka");
        this.putInCache(objects);
        return objects;
    }

    private void putInCache(List<T> objects) {
        Method getIdMethod = CommonUtils.getMethod("getId", CommonUtils.getObjClass(objects));
        Map<String, Object> objMap = objects.stream().collect(Collectors.toMap(obj -> (String)ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)obj), obj -> obj));
        this.redisTemplate.opsForHash().putAll((Object)this.tableName, objMap);
        this.redisTemplate.expire((Object)this.tableName, Long.parseLong(this.timeToLive), TimeUnit.SECONDS);
    }

    public List<T> find(Object searchObject, Integer limit, Integer offset, String tenantId, Long lastChangedSince, Boolean includeDeleted) throws QueryBuilderException {
        String query = this.selectQueryBuilder.build(searchObject);
        query = query + " and tenantId=:tenantId ";
        if (Boolean.FALSE.equals(includeDeleted)) {
            query = query + "and isDeleted=:isDeleted ";
        }
        if (lastChangedSince != null) {
            query = query + "and lastModifiedTime>=:lastModifiedTime ";
        }
        query = query + "ORDER BY id ASC LIMIT :limit OFFSET :offset";
        Map<String, Object> paramsMap = this.selectQueryBuilder.getParamsMap();
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("isDeleted", includeDeleted);
        paramsMap.put("lastModifiedTime", lastChangedSince);
        paramsMap.put("limit", limit);
        paramsMap.put("offset", offset);
        return this.namedParameterJdbcTemplate.query(query, paramsMap, this.rowMapper);
    }
}

