/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.service;

import digit.models.coremodels.IdGenerationRequest;
import digit.models.coremodels.IdGenerationResponse;
import digit.models.coremodels.IdRequest;
import digit.models.coremodels.IdResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.http.client.ServiceRequestClient;
import org.egov.tracer.model.CustomException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnExpression(value="!'${egov.idgen.integration.enabled}'.isEmpty() && ${egov.idgen.integration.enabled:false} && !'${egov.idgen.host}'.isEmpty() && !'${egov.idgen.path}'.isEmpty()")
public class IdGenService {
    private final String idGenHost;
    private final String idGenPath;
    private final ServiceRequestClient restRepo;

    @Autowired
    public IdGenService(ServiceRequestClient restRepo, @Value(value="${egov.idgen.host}") String idGenHost, @Value(value="${egov.idgen.path}") String idGenPath) {
        this.restRepo = restRepo;
        this.idGenHost = idGenHost;
        this.idGenPath = idGenPath;
    }

    public List<String> getIdList(RequestInfo requestInfo, String tenantId, String idName, String idFormat, Integer count) throws Exception {
        ArrayList<IdRequest> reqList = new ArrayList<IdRequest>();
        for (int i = 0; i < count; ++i) {
            reqList.add(IdRequest.builder().idName(idName).format(idFormat).tenantId(tenantId).build());
        }
        IdGenerationRequest request = IdGenerationRequest.builder().idRequests(reqList).requestInfo(requestInfo).build();
        StringBuilder uri = new StringBuilder(this.idGenHost).append(this.idGenPath);
        IdGenerationResponse response = this.restRepo.fetchResult(uri, request, IdGenerationResponse.class);
        List idResponses = response.getIdResponses();
        if (CollectionUtils.isEmpty((Collection)idResponses)) {
            throw new CustomException("IDGEN_ERROR", "No ids returned from idgen Service");
        }
        return idResponses.stream().map(IdResponse::getId).collect(Collectors.toList());
    }
}

